/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class Platform {
    private Game g;
    protected int x;
    private int y;
    private int height;
    private int width;
    protected boolean black;
    Sprite sprite;
    Rectangle hitbox;

    public Platform(Game g, String r, int x, int y, int height, int width, boolean black) {
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
        this.black = black;
        this.g = g;
        this.sprite = SpriteStore.get().getSprite(r);
        this.hitbox = new Rectangle(x, y, width, height);
    }

    public void draw(Graphics2D gtd) {
        this.sprite.draw(gtd, this.x, this.y, this.width, this.height);
    }

    public Rectangle getHitbox() {
        return this.hitbox;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public int getWidth() {
        return this.width;
    }

    public void setX(int x) {
        this.x = x;
        this.hitbox.setLocation(x, this.y);
    }

    public void setY(int y) {
        this.y = y;
        this.hitbox.setLocation(this.x, y);
    }

    public void collidedWith(Entity other) {
        if (other instanceof ShipEntity) {
            ShipEntity temp = (ShipEntity)other;
            if (!(temp.black == this.black && this.y + this.sprite.getHeight() - other.getY() >= 0 || temp.black == this.black && this.y - other.getY() < 0)) {
                this.g.notifyDeath();
            }
        }
    }
}

