/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Game
extends Canvas {
    private BufferStrategy strategy;
    private boolean onPlatform = true;
    private boolean spacePressed = false;
    private boolean gamePaused = false;
    private int jetHealth = 25;
    protected final int GAME_WIDTH = 1920;
    protected final int GAME_HEIGHT = 1080;
    private boolean gameRunning = true;
    private ArrayList<Entity> entities = new ArrayList();
    private ArrayList<String> text = new ArrayList();
    private ArrayList<ArrayList<Platform>> walls = new ArrayList();
    private ArrayList<EndPortal> ends = new ArrayList();
    private ArrayList<Entity> removeEntities = new ArrayList();
    private Entity ship;
    private double changeInterval = 500.0;
    private double lastChange = 0.0;
    private boolean upPressed = false;
    private boolean isJumping = false;
    private double shipYVelocity = 0.0;
    private double gravity = 7500.0;
    private double jumpStrength = -870.0;
    private double groundY = 1013.0;
    private double clickDelay = 300.0;
    private double lastClick = 0.0;
    private String message = "";
    private double jumpInterval = 3.0;
    private double lastJump = 0.0;
    protected static int state = -1;
    private int lastState = 0;
    private static Clip bgMusic;
    private int mouseX;
    private int mouseY;
    private ArrayList<Button> buttons = new ArrayList();
    private long lastTutorial = 0L;
    private int tutorialPaused = 0;
    private Image img;
    private Image logo;
    private Image dead;
    private Image win;
    private int animationInterval = 75;
    private long lastAniSwitch;
    private int animationIndex = 1;
    private int deaths = 0;
    private int jumps = 0;
    private int switches = 0;

    public Game() {
        JFrame container = new JFrame("Run Away");
        JPanel panel = (JPanel)container.getContentPane();
        panel.setPreferredSize(new Dimension(1920, 1080));
        panel.setLayout(null);
        this.setBounds(0, 0, 1920, 1080);
        panel.add(this);
        this.setIgnoreRepaint(true);
        container.pack();
        container.setResizable(false);
        container.setVisible(true);
        container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(new KeyInputHandler());
        this.addMouseListener(new MouseClickHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
        this.requestFocus();
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
        this.initEntities();
        this.initPlatforms();
        this.initEnd();
        this.createMenu();
        this.createFirstLevelMenu();
        this.createSecondLevelMenu();
        Game.playSound("FinalSong.wav");
        this.gameLoop();
    }

    private void initEntities() {
        this.ship = new ShipEntity(this, "red/run1.png", 30, 733);
        this.entities.add(this.ship);
    }

    private void initText() {
        this.message = "Press the up arrow key to jump, you can hold down the jump button to jump longer";
        this.text.add(this.message);
        this.message = "Press the p button to pause the game";
        this.text.add(this.message);
        this.message = "press the space button to switch colours, if you are the wrong colour on a platform you will die :(";
        this.text.add(this.message);
        this.message = "Test it out a bit with these platforms";
        this.text.add(this.message);
    }

    private void initPlatforms() {
        ArrayList<Platform> levelWalls = new ArrayList<Platform>();
        Platform wall = new Platform(this, "sprites/red.jpg", 0, 700, 100, 1920, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 1920, 700, 100, 1920, true);
        levelWalls.add(wall);
        this.walls.add(levelWalls);
        levelWalls = new ArrayList();
        wall = new Platform(this, "sprites/red.jpg", -400, 700, 75, 1800, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 2000, 600, 75, 800, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 3400, 700, 75, 800, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 4800, 600, 75, 800, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 6200, 500, 75, 800, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 7600, 800, 75, 1800, true);
        levelWalls.add(wall);
        this.walls.add(levelWalls);
        levelWalls = new ArrayList();
        wall = new Platform(this, "sprites/red.jpg", -400, 700, 75, 1800, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 2000, 600, 75, 800, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 3000, 700, 75, 800, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 4000, 800, 75, 400, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 4800, 900, 75, 400, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 5400, 700, 75, 400, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 6000, 600, 75, 500, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 7000, 500, 75, 500, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 8250, 800, 75, 1000, false);
        levelWalls.add(wall);
        this.walls.add(levelWalls);
        levelWalls = new ArrayList();
        wall = new Platform(this, "sprites/red.jpg", -400, 700, 50, 2000, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 2000, 600, 50, 1000, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 3000, 700, 50, 800, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 4000, 600, 50, 400, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 4800, 800, 50, 800, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 4800, 400, 50, 400, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 5800, 700, 50, 400, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 5400, 400, 50, 400, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 6800, 800, 50, 500, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 6400, 500, 50, 500, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 7800, 900, 50, 500, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 7400, 400, 50, 500, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 8250, 800, 50, 1000, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 9500, 600, 50, 500, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 10500, 500, 50, 500, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 11500, 600, 50, 500, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 12500, 400, 50, 500, true);
        levelWalls.add(wall);
        this.walls.add(levelWalls);
        levelWalls = new ArrayList();
        wall = new Platform(this, "sprites/red.jpg", -400, 700, 50, 2000, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 2100, 500, 50, 1000, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 3600, 800, 50, 500, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 4350, 700, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 4850, 600, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 5600, 700, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 6000, 800, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 6750, 600, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 7500, 500, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 8500, 400, 50, 250, true);
        levelWalls.add(wall);
        this.walls.add(levelWalls);
        levelWalls = new ArrayList();
        wall = new Platform(this, "sprites/red.jpg", -400, 700, 50, 1500, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 1600, 500, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 2250, 500, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 3250, 800, 50, 500, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 4000, 700, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 4750, 600, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 5250, 700, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 5750, 500, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 6250, 800, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 7250, 500, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 7750, 700, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 8250, 600, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 9000, 400, 50, 250, false);
        levelWalls.add(wall);
        this.walls.add(levelWalls);
        levelWalls = new ArrayList();
        wall = new Platform(this, "sprites/red.jpg", -400, 700, 50, 2000, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 2000, 500, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 2500, 600, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 3000, 700, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 3500, 600, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 4000, 500, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 4500, 600, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 5000, 800, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 6000, 600, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 7000, 800, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 8000, 600, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 8500, 800, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 9500, 600, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 10000, 550, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 10500, 450, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 11000, 300, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 12000, 850, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 13000, 850, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 14000, 700, 50, 250, false);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/green.jpg", 15000, 600, 50, 250, true);
        levelWalls.add(wall);
        wall = new Platform(this, "sprites/red.jpg", 16250, 500, 50, 250, false);
        levelWalls.add(wall);
        this.walls.add(levelWalls);
    }

    private void initEnd() {
        EndPortal end = new EndPortal(this, "sprites/endPortal.png", 9000, 680);
        this.ends.add(end);
        end = new EndPortal(this, "sprites/endPortal.png", 8650, 680);
        this.ends.add(end);
        end = new EndPortal(this, "sprites/endPortal.png", 12900, 280);
        this.ends.add(end);
        end = new EndPortal(this, "sprites/endPortal.png", 8625, 280);
        this.ends.add(end);
        end = new EndPortal(this, "sprites/endPortal.png", 9125, 280);
        this.ends.add(end);
        end = new EndPortal(this, "sprites/endPortal.png", 16375, 380);
        this.ends.add(end);
    }

    public ArrayList<Entity> getEntities() {
        return this.entities;
    }

    public void removeEntity(Entity entity) {
        this.removeEntities.add(entity);
    }

    public void notifyDeath() {
        state = -7;
    }

    public void notifyWin() {
        this.message = "The jocks are dead. Leo wins!";
        state = -1;
    }

    public void setGround(double groundY) {
        this.groundY = groundY;
    }

    public void tryChangeColour() {
        if ((double)System.currentTimeMillis() - this.lastChange < this.changeInterval) {
            return;
        }
        this.lastChange = System.currentTimeMillis();
        this.ship.setColour(!this.ship.getColour());
        ++this.switches;
    }

    public void gameLoop() {
        long lastLoopTime = System.currentTimeMillis();
        BufferedImage back = null;
        Background backOne = new Background();
        Background backTwo = new Background(backOne.getImageWidth(), 0, 1.0);
        Background backThree = new Background(0, 0, 2.5);
        Background backFour = new Background(backThree.getImageWidth(), 0, 2.5);
        Background backFive = new Background(0, 0, 5.0);
        Background backSix = new Background(backThree.getImageWidth(), 0, 5.0);
        try {
            this.img = ImageIO.read(this.getClass().getResource("/sprites/menu.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.logo = ImageIO.read(this.getClass().getResource("/sprites/logo.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (this.gameRunning) {
            Graphics2D buffer2;
            long delta = System.currentTimeMillis() - lastLoopTime;
            lastLoopTime = System.currentTimeMillis();
            Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
            g.drawImage(this.img, 0, 0, null);
            if (state == -1) {
                g.drawImage(this.logo, 250, 10, null);
            }
            if (state >= 0 && !this.gamePaused && this.tutorialPaused == 0) {
                if (back == null) {
                    back = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
                }
                buffer2 = back.createGraphics();
                backOne.draw(buffer2);
                backTwo.draw(buffer2);
                g.drawImage(back, null, 0, 0);
            }
            if (state >= 0 && !this.gamePaused) {
                if (back == null) {
                    back = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
                }
                buffer2 = back.createGraphics();
                backOne.draw(buffer2);
                backTwo.draw(buffer2);
                backThree.draw(buffer2);
                backFour.draw(buffer2);
                backFive.draw(buffer2);
                backSix.draw(buffer2);
                g.drawImage(back, null, 0, 0);
            }
            if (this.gamePaused) {
                g.setColor(Color.white);
                this.message = "Press P to continue";
                g.drawString(this.message, (1920 - g.getFontMetrics().stringWidth(this.message)) / 2, 490);
                this.strategy.show();
                try {
                    Thread.sleep(5L);
                }
                catch (Exception buffer2) {}
                continue;
            }
            if (this.tutorialPaused == 1) {
                try {
                    Thread.sleep(5L);
                }
                catch (Exception buffer2) {}
                continue;
            }
            if (state >= 0 && !this.gamePaused) {
                int i = 0;
                while (i < this.entities.size()) {
                    Iterator<Platform> entity = this.entities.get(i);
                    ((Entity)((Object)entity)).move(delta);
                    for (Platform wall : this.walls.get(state)) {
                        wall.setX(wall.getX() - 30);
                        if (state != 0) continue;
                        if (wall.getX() <= -800 && state > 0) {
                            wall.setX(1920);
                            continue;
                        }
                        if (wall.getX() > -1920 || state != 0) continue;
                        wall.setX(1920);
                    }
                    if (state > 0) {
                        EndPortal end = this.ends.get(state - 1);
                        end.setX(end.getX() - 30);
                    }
                    ++i;
                }
            }
            if (state >= 0) {
                for (Entity entity : this.entities) {
                    entity.draw(g);
                }
                for (Platform wall : this.walls.get(state)) {
                    wall.draw(g);
                }
                if (state > 0) {
                    EndPortal end = this.ends.get(state - 1);
                    end.draw(g);
                }
            }
            if (state == 0 && !this.gamePaused) {
                g.setColor(Color.white);
                try {
                    InputStream is = this.getClass().getResourceAsStream("fonts/ComingSoon-Regular.ttf");
                    Font customFont = Font.createFont(0, is);
                    Font sizedFont = customFont.deriveFont(0, 25.0f);
                    g.setFont(sizedFont);
                }
                catch (FontFormatException | IOException e) {
                    e.printStackTrace();
                }
                g.drawString(this.text.get(0), (1920 - g.getFontMetrics().stringWidth(this.message)) / 2, 200);
                g.drawString(this.text.get(1), (1920 - g.getFontMetrics().stringWidth(this.message)) / 2, 300);
                g.drawString(this.text.get(2), (1920 - g.getFontMetrics().stringWidth(this.message)) / 2, 400);
                g.drawString(this.text.get(3), (1920 - g.getFontMetrics().stringWidth(this.message)) / 2, 500);
            }
            int i = 0;
            while (i < this.entities.size()) {
                Entity me = this.entities.get(i);
                Platform him = new Platform(this, "sprites/red.jpg", 1000, 600, 100, 800, true);
                if (state >= 0) {
                    EndPortal end;
                    if (state > 0 && me.collidesWith(end = this.ends.get(state - 1))) {
                        me.collidedWith(end);
                        end.collidedWith(me);
                    }
                    if (state >= 0) {
                        for (Platform wall : this.walls.get(state)) {
                            him = wall;
                            if (!me.collidesWith(him)) continue;
                            me.collidedWith(him);
                            him.collidedWith(me);
                        }
                    }
                }
                ++i;
            }
            Rectangle hitBox = new Rectangle(this.ship.getX(), this.ship.getY(), this.ship.sprite.getWidth(), this.ship.sprite.getHeight());
            hitBox.y = (int)((double)hitBox.y + this.ship.dy);
            if (state >= 0) {
                for (Platform p : this.walls.get(state)) {
                    if (hitBox.intersects(p.getHitbox()) && hitBox.x >= p.getX() && hitBox.x <= p.getX() + p.getWidth()) {
                        this.onPlatform = true;
                        hitBox.y = (int)((double)hitBox.y - this.ship.dy);
                        hitBox.y = p.getY() - this.ship.sprite.getHeight();
                        this.isJumping = false;
                        this.ship.dy = 0.0;
                        this.ship.setY(hitBox.y + 1);
                        this.jetHealth = 25;
                        break;
                    }
                    this.onPlatform = false;
                }
            }
            hitBox.x = (int)((double)hitBox.x + this.ship.dx);
            if (state >= 0) {
                for (Platform p : this.walls.get(state)) {
                    if (!hitBox.intersects(p.getHitbox())) continue;
                    hitBox.x = (int)((double)hitBox.x - this.ship.dx);
                    hitBox.x = p.getX() - this.ship.sprite.getWidth();
                    this.ship.dx = 0.0;
                    this.ship.setX(hitBox.x + 1);
                    break;
                }
            }
            if (!this.onPlatform) {
                this.isJumping = true;
            }
            this.entities.removeAll(this.removeEntities);
            this.removeEntities.clear();
            if ((double)this.ship.getY() == this.groundY && state >= 0) {
                this.notifyDeath();
            }
            if (this.ship.getX() >= 1870) {
                this.ship.setX(0.0);
            }
            if (this.spacePressed) {
                this.tryChangeColour();
            }
            if (state == -1) {
                this.startScreen(g);
            } else if (state == -2) {
                this.firstLevelMenu(g);
            } else if (state == -3) {
                this.secondLevelMenu(g);
            }
            if (state == -4) {
                this.winScreen(g);
            }
            if (state == -7) {
                this.loseScreen(g);
            }
            g.dispose();
            this.strategy.show();
            this.ship.setHorizontalMovement(0.0);
            if (System.currentTimeMillis() - this.lastAniSwitch > (long)this.animationInterval) {
                if (this.ship.getColour()) {
                    this.ship.setSprite("green/run" + this.animationIndex + ".png");
                } else {
                    this.ship.setSprite("red/run" + this.animationIndex + ".png");
                }
                ++this.animationIndex;
                if (this.animationIndex > 3) {
                    this.animationIndex = 1;
                }
                this.lastAniSwitch = System.currentTimeMillis();
            }
            if (this.upPressed && this.jetHealth > 0) {
                this.isJumping = true;
                this.shipYVelocity = this.jumpStrength;
                if (System.currentTimeMillis() - this.lastAniSwitch > (long)(this.animationInterval * 3)) {
                    if (this.ship.getColour()) {
                        this.ship.setSprite("green/jump1.png");
                    } else {
                        this.ship.setSprite("red/jump1.png");
                    }
                }
            }
            if (this.isJumping) {
                --this.jetHealth;
                double deltaSeconds = (double)delta / 1000.0;
                this.shipYVelocity += this.gravity * deltaSeconds;
                if (this.ship.getColour()) {
                    if (this.shipYVelocity > 0.0) {
                        this.ship.setSprite("green/jump3.png");
                    } else if (this.shipYVelocity < 0.0) {
                        this.ship.setSprite("green/jump2.png");
                    }
                } else if (this.shipYVelocity > 0.0) {
                    this.ship.setSprite("red/jump3.png");
                } else if (this.shipYVelocity < 0.0) {
                    this.ship.setSprite("red/jump2.png");
                }
                double newY = (double)this.ship.getY() + this.shipYVelocity * deltaSeconds;
                if (newY >= this.groundY) {
                    newY = this.groundY;
                    this.isJumping = false;
                    this.shipYVelocity = 0.0;
                }
                this.ship.setY(newY);
                this.lastJump = System.currentTimeMillis();
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (state != -6) continue;
            System.exit(0);
        }
    }

    private void startGame() {
        this.entities.clear();
        this.walls.clear();
        this.ends.clear();
        this.initEntities();
        this.initPlatforms();
        this.initEnd();
        Game.playSound("elevatorMusic.wav");
        this.spacePressed = false;
        this.upPressed = false;
        this.onPlatform = false;
    }

    private void tutorial() {
        this.entities.clear();
        this.walls.clear();
        this.initEntities();
        this.initPlatforms();
        this.initText();
        Game.playSound("elevatorMusic.wav");
        this.spacePressed = false;
        this.onPlatform = false;
        this.tutorialPaused = 0;
        this.lastTutorial = System.currentTimeMillis();
        while (System.currentTimeMillis() <= this.lastTutorial + 1800L) {
        }
        this.tutorialPaused = 1;
        this.lastTutorial = System.currentTimeMillis();
    }

    private void createMenu() {
        this.buttons.add(new Button(this, "sprites/start.jpg", 780.0, 200.0, -2));
        this.buttons.add(new Button(this, "sprites/exit.jpg", 780.0, 350.0, -6));
        this.buttons.add(new Button(this, "sprites/tutorial.jpg", 780.0, 500.0, 0));
    }

    private void createFirstLevelMenu() {
        this.buttons.add(new Button(this, "sprites/levelOne.jpg", 780.0, 200.0, 1));
        this.buttons.add(new Button(this, "sprites/levelTwo.jpg", 780.0, 350.0, 2));
        this.buttons.add(new Button(this, "sprites/levelThree.jpg", 780.0, 500.0, 3));
        this.buttons.add(new Button(this, "sprites/back.jpg", 75.0, 850.0, -1));
        this.buttons.add(new Button(this, "sprites/next.jpg", 1485.0, 850.0, -3));
        this.buttons.add(new Button(this, "sprites/restart.jpg", 780.0, 750.0, this.lastState));
        this.buttons.add(new Button(this, "sprites/return.jpg", 780.0, 600.0, -2));
    }

    private void createSecondLevelMenu() {
        this.buttons.add(new Button(this, "sprites/levelFour.jpg", 780.0, 200.0, 4));
        this.buttons.add(new Button(this, "sprites/levelFive.jpg", 780.0, 350.0, 5));
        this.buttons.add(new Button(this, "sprites/levelSix.jpg", 780.0, 500.0, 6));
        this.buttons.add(new Button(this, "sprites/back.jpg", 75.0, 850.0, -2));
        this.buttons.add(new Button(this, "sprites/restart.jpg", 780.0, 750.0, this.lastState));
        this.buttons.add(new Button(this, "sprites/return.jpg", 780.0, 600.0, -2));
    }

    public static synchronized void playSound(String ref) {
        try {
            URL url;
            if (bgMusic != null && bgMusic.isRunning()) {
                bgMusic.stop();
                bgMusic.close();
            }
            if ((url = Game.class.getClassLoader().getResource("sounds/" + ref)) == null) {
                System.out.println("Failed to load: " + ref);
                return;
            }
            AudioInputStream inputStream = AudioSystem.getAudioInputStream(url);
            bgMusic = AudioSystem.getClip();
            bgMusic.open(inputStream);
            if (ref.equals("elevatorMusic.wav") && state >= 0) {
                bgMusic.loop(-1);
            } else {
                bgMusic.start();
            }
            if (ref.equals("FinalSong.wav")) {
                bgMusic.loop(-1);
            } else {
                bgMusic.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startScreen(Graphics g) {
        if (state == -1) {
            int i = 0;
            while (i < 3) {
                this.buttons.get(i).draw(g);
                ++i;
            }
        }
    }

    private void firstLevelMenu(Graphics g) {
        int i = 3;
        while (i < 8) {
            this.buttons.get(i).draw(g);
            ++i;
        }
    }

    private void secondLevelMenu(Graphics g) {
        int i = 10;
        while (i < 14) {
            this.buttons.get(i).draw(g);
            ++i;
        }
    }

    private void winScreen(Graphics g) {
        try {
            this.win = ImageIO.read(this.getClass().getResource("/sprites/win.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        g.drawImage(this.win, 460, 100, null);
        g.setColor(Color.white);
        try {
            InputStream is = this.getClass().getResourceAsStream("/fonts/ComingSoon-Regular.ttf");
            if (is != null) {
                Font customFont = Font.createFont(0, is);
                Font sizedFont = customFont.deriveFont(0, 25.0f);
                g.setFont(sizedFont);
            } else {
                System.err.println("Font not found!");
            }
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
        g.drawString("Deaths: " + this.deaths, 510, 500);
        g.drawString("Jumps: " + this.jumps, 510, 600);
        g.drawString("Form Switches: " + this.switches, 510, 700);
        for (Button butt : this.buttons) {
            if (!butt.getText().equals("sprites/return.jpg") || butt.getId() != -2) continue;
            butt.draw(g);
        }
    }

    private void loseScreen(Graphics g) {
        try {
            this.dead = ImageIO.read(this.getClass().getResource("/sprites/dead.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        g.drawImage(this.dead, 410, -150, null);
        for (Button butt : this.buttons) {
            if (!butt.getText().equals("sprites/return.jpg") && !butt.getText().equals("sprites/restart.jpg")) continue;
            butt.draw(g);
        }
    }

    public static void main(String[] args) {
        new Game();
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 80) {
                boolean bl = Game.this.gamePaused = !Game.this.gamePaused;
            }
            if (e.getKeyCode() == 38 && (double)System.currentTimeMillis() - Game.this.lastJump > Game.this.jumpInterval && state >= 0) {
                Game.this.upPressed = true;
                if (Game.this.ship.getColour()) {
                    Game.this.ship.setSprite("green/jump1.png");
                } else {
                    Game.this.ship.setSprite("red/jump1.png");
                }
                Game.this.lastAniSwitch = System.currentTimeMillis();
                if (Game.this.tutorialPaused == 1) {
                    Game.this.tutorialPaused = 0;
                }
            }
            if (e.getKeyCode() == 32) {
                Game.this.spacePressed = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 38 && state >= 0) {
                if (Game.this.upPressed) {
                    ++Game.this.jumps;
                }
                Game.this.upPressed = false;
            }
            if (e.getKeyCode() == 32 && state >= 0) {
                Game.this.spacePressed = false;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                System.exit(0);
            }
        }
    }

    private class MouseClickHandler
    extends MouseAdapter {
        private MouseClickHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int j;
            Object button;
            int i;
            Game.this.mouseX = e.getX();
            Game.this.mouseY = e.getY();
            if (state == -1) {
                Game.this.lastClick = System.currentTimeMillis();
                i = 0;
                while (i < 3) {
                    button = Game.this.buttons.get(i);
                    state = ((Button)button).isClicked(Game.this.mouseX, Game.this.mouseY);
                    if (state == -2) break;
                    if (state == 0) {
                        Game.this.lastState = state;
                        Game.this.tutorial();
                        break;
                    }
                    if (state == -6) {
                        System.exit(0);
                    }
                    ++i;
                }
            }
            if (state == -2 && (double)System.currentTimeMillis() - Game.this.lastClick >= Game.this.clickDelay) {
                i = 3;
                while (i <= 9) {
                    button = Game.this.buttons.get(i);
                    state = ((Button)button).isClicked(Game.this.mouseX, Game.this.mouseY);
                    if (state > 0) {
                        Game.this.lastState = state;
                        j = 0;
                        while (j < Game.this.buttons.size()) {
                            if (Game.this.buttons.get(j).getText().equals("sprites/restart.jpg")) {
                                Game.this.buttons.get(j).setId(Game.this.lastState);
                            }
                            ++j;
                        }
                        Game.this.startGame();
                        break;
                    }
                    ++i;
                }
            }
            if (state == -3 && (double)System.currentTimeMillis() - Game.this.lastClick >= Game.this.clickDelay) {
                i = 10;
                while (i <= 15) {
                    button = Game.this.buttons.get(i);
                    state = ((Button)button).isClicked(Game.this.mouseX, Game.this.mouseY);
                    if (state > 0) {
                        Game.this.lastState = state;
                        j = 0;
                        while (j < Game.this.buttons.size()) {
                            if (Game.this.buttons.get(j).getText().equals("sprites/restart.jpg")) {
                                Game.this.buttons.get(j).setId(Game.this.lastState);
                            }
                            ++j;
                        }
                        Game.this.startGame();
                        break;
                    }
                    ++i;
                }
            }
            if (state == -4) {
                for (Button butt : Game.this.buttons) {
                    if (!butt.getText().equals("sprites/return.jpg")) continue;
                    state = butt.isClicked(Game.this.mouseX, Game.this.mouseY);
                    if (state != -2) break;
                    Game.playSound("FinalSong.wav");
                    break;
                }
            }
            if (state == -7) {
                int i2 = 8;
                while (i2 < 10) {
                    Button butt = Game.this.buttons.get(i2);
                    state = butt.isClicked(Game.this.mouseX, Game.this.mouseY);
                    if (state == Game.this.lastState && state > 0) {
                        ++Game.this.deaths;
                        Game.this.startGame();
                        break;
                    }
                    if (state == Game.this.lastState && state == 0) {
                        ++Game.this.deaths;
                        Game.this.tutorial();
                        break;
                    }
                    if (state == -2) {
                        Game.playSound("FinalSong.wav");
                        break;
                    }
                    ++i2;
                }
            }
        }
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Game.this.mouseX = e.getX();
            Game.this.mouseY = e.getY();
            if (state < 0) {
                for (Button b : Game.this.buttons) {
                    b.updateHover(Game.this.mouseX, Game.this.mouseY);
                }
            }
        }
    }
}

