/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

public class knifeEntity
extends Entity {
    private Game game;
    private double angle;
    private long time = System.currentTimeMillis();
    private int drawPositionX;
    private int drawPositionY;

    public knifeEntity(Game g, String r, int x, int y) {
        super(g, r, x, y);
        this.game = g;
        this.drawPositionX = x - this.game.getCameraX();
        this.drawPositionY = y - this.game.getCameraY();
    }

    @Override
    public void move(long delta) {
        if (System.currentTimeMillis() - this.time > 400L) {
            this.game.removeEntity(this);
        }
        this.x = this.game.getX();
        this.y = this.game.getY();
    }

    @Override
    public void draw(Graphics2D g) {
        double vx = this.game.getMouseX() - this.drawPositionX;
        double vy = this.game.getMouseY() - this.drawPositionY;
        this.angle = Math.atan2(vy, vx) + 45.0;
    }

    @Override
    public boolean collidesWith(Entity other) {
        Shape knifeShape = this.getHitbox();
        Rectangle otherRect = new Rectangle(other.getX() - this.game.getCameraX() - other.sprite.getWidth(), other.getY() - this.game.getCameraY() - other.sprite.getHeight(), other.sprite.getWidth(), other.sprite.getHeight());
        Area knifeArea = new Area(knifeShape);
        Area otherArea = new Area(otherRect);
        knifeArea.intersect(otherArea);
        return !knifeArea.isEmpty();
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof Target) {
            this.game.removeEntity(other);
            this.game.notifyWin();
        }
    }

    public Shape getHitbox() {
        Rectangle rect = new Rectangle(this.drawPositionX + 10, this.drawPositionY - 30, this.sprite.getWidth(), this.sprite.getHeight());
        AffineTransform tx = new AffineTransform();
        tx.rotate(this.angle, this.drawPositionX + 20, this.drawPositionY + 20);
        return tx.createTransformedShape(rect);
    }
}

