/*
 * Decompiled with CFR 0.152.
 */
public class ShotEntity
extends Entity {
    private double moveSpeed = 6000.0;
    private boolean used = false;
    private Game game;

    public ShotEntity(Game g, String r, int newX, int newY, int mousePosX, int mousePosY) {
        super(g, r, newX, newY);
        this.game = g;
        double originX = newX;
        double originY = newY;
        newX += g.getCameraX();
        newY += g.getCameraY();
        double vx = (double)(mousePosX - 21) - originX;
        double vy = (double)(mousePosY - 28) - originY;
        double hyp = Math.hypot(vx, vy);
        if (hyp == 0.0) {
            this.dx = 0.0;
            this.dy = -this.moveSpeed;
            return;
        }
        double nx = vx / hyp;
        double ny = vy / hyp;
        this.dx = nx * this.moveSpeed;
        this.dy = ny * this.moveSpeed;
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (this.x > 1000.0 || this.y < 0.0 || this.x < 0.0 || this.y > 1000.0 || this.game.isWon()) {
            this.game.removeEntity(this);
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (this.used) {
            return;
        }
        if (other instanceof AlienEntity) {
            this.summonDead(other);
            this.game.removeEntity(this);
            this.game.removeEntity(other);
            this.game.notifyAlienKilled();
            this.used = true;
        }
        if (other instanceof Target) {
            this.game.removeEntity(other);
            this.game.notifyWin();
        }
        if (!(other instanceof ShipEntity || other instanceof Crosshair || other instanceof AlienEntity || other instanceof Target || other instanceof droppedWeapon || other instanceof AlienDestroyed)) {
            this.used = true;
            this.game.removeEntity(this);
        }
    }

    @Override
    public void collidedWith() {
        if (this.used) {
            return;
        }
        this.used = true;
        this.game.removeEntity(this);
    }

    private void summonDead(Entity alien) {
        AlienDestroyed destroyed = new AlienDestroyed(this.game, "sprites/alienDestroyed.png", alien.getX(), alien.getY(), ((AlienEntity)alien).getAngle());
        this.game.addEntity(destroyed);
    }
}

