/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class ShipEntity
extends Entity {
    protected Game game;
    private double angle;
    private boolean attacking = false;
    private long attackStartTime = 0L;
    private int attackFrame = 0;
    private final int attackFrameCount = 14;
    private final int attackFrameDuration = 25;
    private String[] atkSprites = new String[]{"sprites/attacks/atk.png", "sprites/attacks/atk1.png", "sprites/attacks/atk2.png", "sprites/attacks/atk3.png", "sprites/attacks/atk4.png", "sprites/attacks/atk5.png", "sprites/attacks/atk6.png", "sprites/attacks/atk7.png", "sprites/attacks/atk8.png", "sprites/attacks/atk9.png", "sprites/attacks/atk10.png", "sprites/attacks/atk11.png", "sprites/attacks/atk12.png", "sprites/attacks/atk13.png", "sprites/attacks/atk14.png"};

    public ShipEntity(Game g, String r, int newX, int newY, double angle) {
        super(g, r, newX, newY);
        this.game = g;
        this.angle = angle;
    }

    public void startAttack() {
        if (!this.attacking && !this.game.getWaiting()) {
            this.attacking = true;
            this.attackStartTime = System.currentTimeMillis();
            this.attackFrame = 0;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.game.getWaiting()) {
            double vx = this.game.getMouseX() - 21 - this.getX() + this.game.getCameraX();
            double vy = this.game.getMouseY() - 28 - this.getY() + this.game.getCameraY();
            this.angle = Math.atan2(vy, vx);
            AffineTransform oldTransform = g.getTransform();
            if (this.attacking) {
                long elapsed = System.currentTimeMillis() - this.attackStartTime;
                this.attackFrame = (int)(elapsed / 25L);
                if (this.attackFrame >= 14) {
                    this.attacking = false;
                    this.attackFrame = 13;
                }
                this.sprite = SpriteStore.get().getSprite(this.atkSprites[this.attackFrame]);
            }
            if (this.game.getWeapons() == 1) {
                if (!this.attacking) {
                    this.sprite = SpriteStore.get().getSprite("sprites/ship3.png");
                }
                g.rotate(this.angle, this.getX() - this.game.getCameraX() + 21, this.getY() - this.game.getCameraY() + 28);
            } else if (this.game.getWeapons() == 2) {
                g.rotate(this.angle, this.getX() - this.game.getCameraX() + 21, this.getY() - this.game.getCameraY() + 28);
            } else {
                g.rotate(this.angle, this.getX() - this.game.getCameraX() + 21, this.getY() - this.game.getCameraY() + 28);
            }
            if (this.sprite == SpriteStore.get().getSprite("sprites/ship.png")) {
                this.sprite.draw(g, (int)this.x - this.game.getCameraX() - 10, (int)this.y - this.game.getCameraY() - 10, this.sprite.getWidth() / 3, this.sprite.getHeight() / 3);
            } else if (this.sprite == SpriteStore.get().getSprite("sprites/ship2.png")) {
                this.sprite.draw(g, (int)this.x - this.game.getCameraX() - 10, (int)this.y - this.game.getCameraY() - 10, this.sprite.getWidth() / 3, this.sprite.getHeight() / 3);
            } else if (!this.attacking) {
                this.sprite.draw(g, (int)this.x - this.game.getCameraX() - 10, (int)this.y - this.game.getCameraY() - 10, this.sprite.getWidth() / 3, this.sprite.getHeight() / 3);
            } else {
                this.sprite.draw(g, (int)this.x - this.game.getCameraX() - 10, (int)this.y - this.game.getCameraY() - 10, this.sprite.getWidth() / 3, this.sprite.getHeight() / 3);
            }
            g.setTransform(oldTransform);
        }
    }

    @Override
    public void collidedWith(Entity other) {
        boolean cfr_ignored_0 = other instanceof AlienEntity;
    }

    public double getAngle() {
        return this.angle;
    }
}

