/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Game
extends Canvas {
    private BufferStrategy strategy;
    private boolean waitingForKeyPress = false;
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    private boolean firePressed = false;
    private boolean upPressed = false;
    private boolean attempted = false;
    private final int sleepTime = 5;
    private boolean downPressed = false;
    private int mouseX;
    private int mouseY;
    private boolean pPressed = false;
    private boolean died = false;
    private boolean won = false;
    private Image deathImage;
    private int level = 1;
    private Image winImage;
    private Image finalImage;
    private float fadeAlpha = 0.0f;
    private boolean paused = false;
    private boolean gameRunning = true;
    private ArrayList<Entity> entities = new ArrayList();
    private ArrayList<Entity> removeEntities = new ArrayList();
    Polygon hitBox;
    private Entity ship;
    private Crosshair crosshair;
    private Target target;
    private int ammo = 10;
    private double time = (double)System.currentTimeMillis() / 1000.0;
    private int[][] levelData;
    private double moveSpeed = 350.0;
    private long lastFire = 0L;
    private long firingInterval = 10L;
    private long knifeInterval = 400L;
    URL url = Game.class.getResource("sprites/background.jpg");
    private int alienCount;
    private Image backgroundImage = Toolkit.getDefaultToolkit().getImage(this.url);
    private final int backgroundWidth = 480;
    private final int backgroundHeight = 480;
    private final int screenSize = 1000;
    private final int size = 3000;
    private int cameraX = 0;
    private int cameraY = 0;
    private short weapons = (short)3;
    public static int enemies = 50;
    private int[] obstacleX = new int[200];
    private int[] obstacleY = new int[200];
    private boolean[] direction = new boolean[200];
    private boolean[] obstacleOnScreen = new boolean[200];
    private int[] obstacleWidth = new int[200];
    private int[] obstacleHeight = new int[200];
    public static boolean drawn = false;
    private int shipWidth = 35;
    private int shipHeight = 40;
    private String playaSprite = "sprites/ship.png";
    private int fps = 0;
    private int frameCount = 0;
    private long lastFpsTime = 0L;
    private boolean panning = false;
    private double panOffsetX = 2000.0;
    private double panOffsetY = 2000.0;
    private ArrayList<Rectangle> walls = new ArrayList();
    URL url1 = Game.class.getResource("sprites/died.jpg");
    URL url2 = Game.class.getResource("sprites/winScreen.jpg");
    URL url3 = Game.class.getResource("sprites/winner.png");
    private boolean logicRequiredThisLoop = false;
    public static STATE state = STATE.MENU;
    Menu menu = new Menu();
    MouseInput mouseInput = new MouseInput(this.menu);

    public Game() {
        JFrame container = new JFrame("game");
        JPanel panel = (JPanel)container.getContentPane();
        panel.setPreferredSize(new Dimension(1000, 1000));
        panel.setLayout(null);
        this.setBounds(0, 0, 3000, 3000);
        panel.add(this);
        this.setIgnoreRepaint(true);
        container.pack();
        container.setResizable(false);
        container.setVisible(true);
        container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(new KeyInputHandler());
        this.addMouseListener(new MouseListener());
        this.addMouseMotionListener(new MouseListener());
        this.addMouseListener(new MouseInput(this.menu));
        this.requestFocus();
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
        try {
            this.deathImage = Toolkit.getDefaultToolkit().getImage(this.url1);
            this.winImage = Toolkit.getDefaultToolkit().getImage(this.url2);
            this.finalImage = Toolkit.getDefaultToolkit().getImage(this.url3);
        }
        catch (Exception e) {
            System.out.println("Couldn't load death image");
        }
        this.startGame();
        this.gameLoop();
    }

    private void drawBackground(Graphics2D g, int x, int y) {
        int baseCamX = x - 500;
        int baseCamY = y - 500;
        if (this.panning) {
            baseCamX = (int)((double)baseCamX + this.panOffsetX);
            baseCamY = (int)((double)baseCamY + this.panOffsetY);
        }
        this.cameraX = Math.max(0, Math.min(baseCamX, 2000));
        this.cameraY = Math.max(0, Math.min(baseCamY, 2000));
        int i = 0;
        while (i < this.cameraX + 1000) {
            int j = 0;
            while (j < this.cameraY + 1000) {
                g.drawImage(this.backgroundImage, i - this.cameraX, j - this.cameraY, 480, 480, this);
                j += 480;
            }
            i += 480;
        }
    }

    private void draw(Graphics g, int x, int y, int i, boolean direction) {
        int drawX = x;
        int drawY = y;
        int width = direction ? this.obstacleWidth[i] : this.obstacleHeight[i];
        int height = direction ? this.obstacleHeight[i] : this.obstacleWidth[i];
        Boolean onScreen = drawX + width > this.cameraX && drawX < this.cameraX + 1000 && drawY + height > this.cameraY && drawY < this.cameraY + 1000;
        if (onScreen.booleanValue()) {
            this.obstacleOnScreen[i] = true;
            int screenX = drawX - this.cameraX;
            int screenY = drawY - this.cameraY;
            g.setColor(Color.GRAY);
            if (direction) {
                g.fillRect(screenX, screenY, this.obstacleWidth[i], this.obstacleHeight[i]);
                Rectangle rectangle = new Rectangle(screenX, screenY, this.obstacleWidth[i], this.obstacleHeight[i]);
                this.walls.add(rectangle);
            } else {
                g.fillRect(screenX, screenY, this.obstacleHeight[i], this.obstacleWidth[i]);
                Rectangle rectangle = new Rectangle(screenX, screenY, this.obstacleHeight[i], this.obstacleWidth[i]);
                this.walls.add(rectangle);
            }
        } else {
            this.obstacleOnScreen[i] = false;
        }
    }

    private boolean moveRightAllowed(double x, double y, double px) {
        boolean allowed = true;
        int i = 0;
        while (i < this.obstacleOnScreen.length) {
            if (this.obstacleOnScreen[i]) {
                int obsH;
                int obsX = this.obstacleX[i];
                int obsY = this.obstacleY[i];
                int n = obsH = this.direction[i] ? this.obstacleHeight[i] : this.obstacleWidth[i];
                if (x + (double)this.shipWidth < (double)(obsX + 5) && x + (double)this.shipWidth > (double)(obsX - 5) && y + (double)this.shipHeight > (double)obsY && y < (double)(obsY + obsH)) {
                    allowed = false;
                    break;
                }
            }
            ++i;
        }
        return allowed;
    }

    private boolean moveLeftAllowed(double x, double y, double px) {
        boolean allowed = true;
        int i = 0;
        while (i < this.obstacleOnScreen.length) {
            if (this.obstacleOnScreen[i]) {
                int obsH;
                int obsX = this.obstacleX[i];
                int obsY = this.obstacleY[i];
                int obsW = this.direction[i] ? this.obstacleWidth[i] : this.obstacleHeight[i];
                int n = obsH = this.direction[i] ? this.obstacleHeight[i] : this.obstacleWidth[i];
                if (x > (double)(obsX + obsW - 5) && x < (double)(obsX + obsW + 5) && y + (double)this.shipHeight > (double)obsY && y < (double)(obsY + obsH)) {
                    allowed = false;
                    break;
                }
            }
            ++i;
        }
        return allowed;
    }

    private boolean moveUpAllowed(double x, double y, double py) {
        boolean allowed = true;
        int i = 0;
        while (i < this.obstacleOnScreen.length) {
            if (this.obstacleOnScreen[i]) {
                int obsH;
                int obsX = this.obstacleX[i];
                int obsY = this.obstacleY[i];
                int obsW = this.direction[i] ? this.obstacleWidth[i] : this.obstacleHeight[i];
                int n = obsH = this.direction[i] ? this.obstacleHeight[i] : this.obstacleWidth[i];
                if (y > (double)(obsY + obsH - 5) && y < (double)(obsY + obsH + 5) && x + (double)this.shipWidth > (double)obsX && x < (double)(obsX + obsW)) {
                    allowed = false;
                    break;
                }
            }
            ++i;
        }
        return allowed;
    }

    private boolean moveDownAllowed(double x, double y, double py) {
        boolean allowed = true;
        int i = 0;
        while (i < this.obstacleOnScreen.length) {
            if (this.obstacleOnScreen[i]) {
                int obsW;
                int obsX = this.obstacleX[i];
                int obsY = this.obstacleY[i];
                int n = obsW = this.direction[i] ? this.obstacleWidth[i] : this.obstacleHeight[i];
                if (y + (double)this.shipHeight < (double)(obsY + 5) && y + (double)this.shipHeight > (double)(obsY - 5) && x + (double)this.shipWidth > (double)obsX && x < (double)(obsX + obsW)) {
                    allowed = false;
                    break;
                }
            }
            ++i;
        }
        return allowed;
    }

    private int[][] retrieveLevel(String[] data) {
        this.alienCount = 0;
        int[][] levelData = new int[data.length][5];
        String regex = "[,\\.\\s]";
        int i = 0;
        while (i < data.length) {
            String[] playerData;
            if (data[i].charAt(0) == 'g') {
                ++this.alienCount;
                String[] aliens = data[i].split(regex);
                int k = 0;
                while (k < aliens.length) {
                    levelData[i][0] = Integer.parseInt(aliens[1]);
                    levelData[i][1] = Integer.parseInt(aliens[2]);
                    levelData[i][2] = Integer.parseInt(aliens[3]);
                    levelData[i][3] = Integer.parseInt(aliens[4]);
                    levelData[i][4] = Integer.parseInt(aliens[5]);
                    ++k;
                }
            }
            if (data[i].charAt(0) == 'p') {
                playerData = data[i].split(regex);
                levelData[i][0] = Integer.parseInt(playerData[1]);
                levelData[i][1] = Integer.parseInt(playerData[2]);
            }
            if (data[i].charAt(0) == 't') {
                playerData = data[i].split(regex);
                levelData[i][0] = Integer.parseInt(playerData[1]);
                levelData[i][1] = Integer.parseInt(playerData[2]);
            }
            ++i;
        }
        return levelData;
    }

    private void initEntities(int[][] levelData) {
        int dataSize = levelData.length;
        this.ship = new ShipEntity(this, this.playaSprite, levelData[0][0], levelData[0][1], 0.0);
        this.crosshair = new Crosshair(this, "sprites/crosshair.png", this.getMouseX(), this.getMouseY());
        this.target = new Target(this, "sprites/target.png", levelData[1][0], levelData[1][1]);
        this.entities.add(this.target);
        this.entities.add(this.ship);
        this.entities.add(this.crosshair);
        int col = dataSize - this.alienCount - 1;
        while (col <= this.alienCount) {
            AlienEntity alien = new AlienEntity(this, "sprites/alien.png", levelData[col + 1][0], levelData[col + 1][1], levelData[col + 1][2], levelData[col + 1][3], levelData[col + 1][4]);
            alien.drawVisionTriangle(alien, 1, 0.0);
            this.entities.add(alien);
            ++col;
        }
        if (this.level == 1) {
            this.levelOne();
        } else if (this.level == 2) {
            this.levelTwo();
        }
    }

    public void updateLogic() {
        this.logicRequiredThisLoop = true;
    }

    public void removeEntity(Entity entity) {
        this.removeEntities.add(entity);
    }

    public void notifyDeath() {
        this.died = true;
        this.waitingForKeyPress = true;
    }

    public void notifyWin() {
        if ((double)System.currentTimeMillis() > this.time + 100.0) {
            if (!this.won) {
                ++this.level;
            }
            this.won = true;
            this.time = System.currentTimeMillis();
            this.waitingForKeyPress = true;
        }
    }

    public void notifyAlienKilled() {
        --this.alienCount;
        if (this.alienCount == 79059) {
            this.notifyWin();
        }
    }

    public void tryToFire() {
        if (System.currentTimeMillis() - this.lastFire < this.firingInterval && this.getWeapons() != 1 || this.getWeapons() == 1 && System.currentTimeMillis() - this.lastFire < this.knifeInterval) {
            return;
        }
        if (this.getWeapons() != 1) {
            if ((double)System.currentTimeMillis() > this.time + 100.0) {
                this.lastFire = System.currentTimeMillis();
                --this.ammo;
                ShotEntity shot = new ShotEntity(this, "sprites/shot.png", this.ship.getX() - this.cameraX + 15, this.ship.getY() - this.cameraY + 15, this.getMouseX(), this.getMouseY());
                this.entities.add(shot);
            }
        } else {
            this.lastFire = System.currentTimeMillis();
            knifeEntity knife = new knifeEntity(this, "sprites/knifeTemp.png", (int)this.ship.x, (int)this.ship.y);
            this.entities.add(knife);
            ((ShipEntity)this.ship).startAttack();
            this.attempted = true;
        }
    }

    public void gameLoop() {
        long lastLoopTime = System.currentTimeMillis();
        while (this.gameRunning) {
            if (state == STATE.MENU) {
                if (!drawn) {
                    Graphics g = this.getGraphics();
                    this.menu.draw(g);
                    drawn = true;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException g) {}
                continue;
            }
            if (state == STATE.GAME && this.paused && !this.waitingForKeyPress) {
                this.paused = false;
            }
            if (this.paused && this.waitingForKeyPress) {
                this.time = System.currentTimeMillis();
            }
            long delta = System.currentTimeMillis() - lastLoopTime;
            lastLoopTime = System.currentTimeMillis();
            ++this.frameCount;
            if (System.currentTimeMillis() - this.lastFpsTime >= 1000L) {
                this.fps = this.frameCount;
                this.frameCount = 0;
                this.lastFpsTime = System.currentTimeMillis();
            }
            if (!this.paused) {
                Entity entity;
                Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, 1000, 1000);
                this.drawBackground(g, this.ship.getX(), this.ship.getY());
                int i = 0;
                while (i < this.obstacleX.length) {
                    this.draw(g, this.obstacleX[i], this.obstacleY[i], i, this.direction[i]);
                    ++i;
                }
                if (this.died && this.fadeAlpha < 1.0f || this.isWon() && this.fadeAlpha < 1.0f) {
                    this.fadeAlpha = (float)((double)this.fadeAlpha + 0.005);
                    if (this.fadeAlpha >= 1.0f) {
                        this.fadeAlpha = 1.0f;
                    }
                }
                if (this.died && this.deathImage != null) {
                    Composite original = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, this.fadeAlpha));
                    g.drawImage(this.deathImage, 0, 0, null);
                    g.setComposite(original);
                }
                if (this.isWon() && this.winImage != null && this.level != 4) {
                    Composite original = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, this.fadeAlpha));
                    g.drawImage(this.winImage, 0, 0, null);
                    g.setComposite(original);
                }
                if (this.isWon() && this.level == 4) {
                    Composite original = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, this.fadeAlpha));
                    g.drawImage(this.finalImage, 0, 0, null);
                    g.setComposite(original);
                }
                if (state == STATE.GAME && !this.isPaused() && !this.waitingForKeyPress) {
                    i = 0;
                    while (i < this.entities.size()) {
                        entity = this.entities.get(i);
                        entity.move(delta);
                        ++i;
                    }
                }
                g.setColor(Color.white);
                this.walls.clear();
                if (!this.waitingForKeyPress) {
                    i = 0;
                    while (i < this.obstacleX.length) {
                        this.draw(g, this.obstacleX[i], this.obstacleY[i], i, this.direction[i]);
                        ++i;
                    }
                    i = 0;
                    while (i < this.entities.size()) {
                        entity = this.entities.get(i);
                        if (entity instanceof AlienEntity) {
                            ((AlienEntity)entity).drawAlien(g, this.cameraX, this.cameraY, 1000, 1000);
                        } else if (entity instanceof Target) {
                            ((Target)entity).draw(g, this.cameraX, this.cameraY, 1000, 1000);
                        } else if (!(entity instanceof ShipEntity)) {
                            entity.draw(g);
                        }
                        ++i;
                    }
                    this.ship.draw(g);
                    i = 0;
                    while (i < this.entities.size()) {
                        entity = this.entities.get(i);
                        if (entity instanceof AlienEntity) {
                            ((AlienEntity)entity).drawAlien(g, this.cameraX, this.cameraY, 1000, 1000);
                        }
                        ++i;
                    }
                }
                g.setColor(Color.GREEN);
                g.drawString("FPS: " + this.fps, 20, 20);
                i = 0;
                while (i < this.entities.size()) {
                    int j = i + 1;
                    while (j < this.entities.size()) {
                        Polygon hitBox;
                        Entity me = this.entities.get(i);
                        Entity him = this.entities.get(j);
                        if (him instanceof ShotEntity) {
                            int x = 0;
                            while (x < this.walls.size()) {
                                if (this.walls.get(x).contains(him.x, him.y)) {
                                    him.collidedWith();
                                }
                                ++x;
                            }
                        }
                        if (him instanceof AlienEntity && me instanceof ShipEntity && ((hitBox = him.getZone()).contains(me.x, me.y) || hitBox.contains(me.x + 46.0, me.y + 48.0) || hitBox.contains(me.x, me.y + 48.0) || hitBox.contains(me.x + 46.0, me.y))) {
                            me.collidedWith(him);
                            him.collidedWith(me);
                            this.notifyDeath();
                        }
                        if (him instanceof knifeEntity && !(me instanceof knifeEntity)) {
                            Entity temp = me;
                            me = him;
                            him = temp;
                        }
                        if (me.collidesWith(him)) {
                            me.collidedWith(him);
                            him.collidedWith(me);
                        }
                        ++j;
                    }
                    ++i;
                }
                this.entities.removeAll(this.removeEntities);
                this.removeEntities.clear();
                if (this.logicRequiredThisLoop && !this.isPaused()) {
                    i = 0;
                    while (i < this.entities.size()) {
                        Entity entity2 = this.entities.get(i);
                        entity2.doLogic();
                        ++i;
                    }
                    this.logicRequiredThisLoop = false;
                }
                g.setColor(Color.white);
                if (!this.waitingForKeyPress) {
                    if (this.weapons == 3) {
                        g.drawString(String.valueOf(this.ammo) + "/10", this.ship.getX() - this.cameraX - 40, this.ship.getY() - this.cameraY - 20);
                    } else if (this.weapons == 2) {
                        g.drawString(String.valueOf(this.ammo) + "/5", this.ship.getX() - this.cameraX - 20, this.ship.getY() - this.cameraY - 20);
                    }
                }
                g.dispose();
                this.strategy.show();
                if (this.ammo == 0 && this.getWeapons() == 3) {
                    this.panning = false;
                    this.panOffsetX = 0.0;
                    this.panOffsetY = 0.0;
                    droppedWeapon dropped = new droppedWeapon(this, "sprites/gun.png", (int)this.ship.x, (int)this.ship.y);
                    this.entities.add(dropped);
                    this.ship.setSprite("sprites/ship2.png");
                    this.weapons = (short)2;
                    this.ammo = 5;
                }
                if (this.ammo == 0 && this.getWeapons() == 2) {
                    droppedWeapon dropped = new droppedWeapon(this, "sprites/gun1.png", (int)this.ship.x, (int)this.ship.y);
                    this.entities.add(dropped);
                    this.ship.setSprite("sprites/ship3.png");
                    this.weapons = 1;
                }
                this.ship.setHorizontalMovement(0.0);
                this.ship.setVerticalMovement(0.0);
                if (!this.panning && state == STATE.GAME) {
                    if (this.leftPressed && !this.rightPressed) {
                        if (this.ship.moveX(delta) > 55.0 && this.moveLeftAllowed(this.ship.moveX(delta), this.ship.moveY(delta), this.ship.getX())) {
                            if (this.upPressed || this.downPressed) {
                                this.ship.setHorizontalMovement(-this.moveSpeed / (Math.sqrt(2.0) * Math.sqrt(2.0)));
                            } else {
                                this.ship.setHorizontalMovement(-this.moveSpeed);
                            }
                        }
                    } else if (this.rightPressed && !this.leftPressed && this.ship.moveX(delta) < 2945.0 && this.moveRightAllowed(this.ship.moveX(delta), this.ship.moveY(delta), this.ship.getX())) {
                        if (this.upPressed || this.downPressed) {
                            this.ship.setHorizontalMovement(this.moveSpeed / (Math.sqrt(2.0) * Math.sqrt(2.0)));
                        } else {
                            this.ship.setHorizontalMovement(this.moveSpeed);
                        }
                    }
                    if (this.upPressed && !this.downPressed) {
                        if (this.ship.moveY(delta) > 55.0 && this.moveUpAllowed(this.ship.moveX(delta), this.ship.moveY(delta), this.ship.getY())) {
                            if (this.rightPressed || this.leftPressed) {
                                this.ship.setVerticalMovement(-this.moveSpeed / Math.sqrt(2.0));
                            } else {
                                this.ship.setVerticalMovement(-this.moveSpeed);
                            }
                        }
                    } else if (this.downPressed && !this.upPressed && this.ship.moveY(delta) < 2945.0 && this.moveDownAllowed(this.ship.moveX(delta), this.ship.moveY(delta), this.ship.getY())) {
                        if (this.rightPressed || this.leftPressed) {
                            this.ship.setVerticalMovement(this.moveSpeed / Math.sqrt(2.0));
                        } else {
                            this.ship.setVerticalMovement(this.moveSpeed);
                        }
                    }
                }
                if (this.firePressed) {
                    this.tryToFire();
                }
                if (System.currentTimeMillis() - this.lastFire > this.knifeInterval && this.attempted && this.weapons == 1) {
                    this.attempted = false;
                }
                this.firePressed = false;
                this.crosshair.set(this.getMouseX() - 15, this.getMouseY() - 15);
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startGame() {
        this.ammo = 10;
        this.clearObstacles();
        this.won = false;
        this.fadeAlpha = 0.0f;
        this.died = false;
        this.alienCount = 0;
        if (this.level == 1) {
            this.levelData = this.retrieveLevel(Game.getFileContents("sprites/level.txt"));
        } else if (this.level == 2) {
            this.levelData = this.retrieveLevel(Game.getFileContents("sprites/level2.txt"));
        } else if (this.level == 3) {
            this.levelData = this.retrieveLevel(Game.getFileContents("sprites/level3.txt"));
        }
        this.entities.clear();
        this.initEntities(this.levelData);
        this.weapons = (short)3;
        this.leftPressed = false;
        this.rightPressed = false;
        this.firePressed = false;
        this.upPressed = false;
        this.downPressed = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getCameraX() {
        return this.cameraX;
    }

    public int getCameraY() {
        return this.cameraY;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean[] getObstacleOnScreen() {
        return this.obstacleOnScreen;
    }

    public int[] getObstacleX() {
        return this.obstacleX;
    }

    public int[] getObstacleY() {
        return this.obstacleY;
    }

    public boolean[] getDirection() {
        return this.direction;
    }

    public static String[] getFileContents(String fileName) {
        String[] contents = null;
        int length = 0;
        try {
            String folderName = "/subFolder/";
            String resource = fileName;
            InputStream input = Game.class.getResourceAsStream(String.valueOf(folderName) + resource);
            if (input == null) {
                input = Game.class.getClassLoader().getResourceAsStream(resource);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            in.mark(Short.MAX_VALUE);
            while (in.readLine() != null) {
                ++length;
            }
            in.reset();
            contents = new String[length];
            int i = 0;
            while (i < length) {
                contents[i] = in.readLine();
                ++i;
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println("File Input Error");
        }
        return contents;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public void setMouseX(int mouseX) {
        this.mouseX = mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public void setMouseY(int mouseY) {
        this.mouseY = mouseY;
    }

    public short getWeapons() {
        return this.weapons;
    }

    public boolean getWaiting() {
        return this.waitingForKeyPress;
    }

    public void setWeapons(short weapons) {
        this.weapons = weapons;
    }

    public void levelOne() {
        this.obstacleX[0] = 25;
        this.obstacleY[0] = 25;
        this.obstacleWidth[0] = 340;
        this.obstacleHeight[0] = 40;
        this.direction[0] = true;
        this.obstacleX[1] = 25;
        this.obstacleY[1] = 25;
        this.obstacleWidth[1] = 340;
        this.obstacleHeight[1] = 40;
        this.direction[1] = false;
        this.obstacleX[2] = 25;
        this.obstacleY[2] = 365;
        this.obstacleWidth[2] = 280;
        this.obstacleHeight[2] = 40;
        this.direction[2] = true;
        this.obstacleX[3] = 365;
        this.obstacleY[3] = 25;
        this.obstacleWidth[3] = 280;
        this.obstacleHeight[3] = 40;
        this.direction[3] = false;
        this.obstacleX[4] = 365;
        this.obstacleY[4] = 280;
        this.obstacleWidth[4] = 1015;
        this.obstacleHeight[4] = 40;
        this.direction[4] = true;
        this.obstacleX[5] = 280;
        this.obstacleY[5] = 365;
        this.obstacleWidth[5] = 400;
        this.obstacleHeight[5] = 40;
        this.direction[5] = false;
        this.obstacleX[6] = 480;
        this.obstacleY[6] = 460;
        this.obstacleWidth[6] = 900;
        this.obstacleHeight[6] = 40;
        this.direction[6] = true;
        this.obstacleX[7] = 480;
        this.obstacleY[7] = 460;
        this.obstacleWidth[7] = 400;
        this.obstacleHeight[7] = 40;
        this.direction[7] = false;
        this.obstacleX[8] = 50;
        this.obstacleY[8] = 735;
        this.obstacleWidth[8] = 270;
        this.obstacleHeight[8] = 40;
        this.direction[8] = true;
        this.obstacleX[9] = 50;
        this.obstacleY[9] = 735;
        this.obstacleWidth[9] = 220;
        this.obstacleHeight[9] = 40;
        this.direction[9] = false;
        this.obstacleX[10] = 50;
        this.obstacleY[10] = 955;
        this.obstacleWidth[10] = 270;
        this.obstacleHeight[10] = 40;
        this.direction[10] = true;
        this.obstacleX[11] = 280;
        this.obstacleY[11] = 955;
        this.obstacleWidth[11] = 460;
        this.obstacleHeight[11] = 40;
        this.direction[11] = false;
        this.obstacleX[12] = 480;
        this.obstacleY[12] = 860;
        this.obstacleWidth[12] = 220;
        this.obstacleHeight[12] = 40;
        this.direction[12] = false;
        this.obstacleX[13] = 480;
        this.obstacleY[13] = 1080;
        this.obstacleWidth[13] = 95;
        this.obstacleHeight[13] = 40;
        this.direction[13] = false;
        this.obstacleX[14] = 480;
        this.obstacleY[14] = 1175;
        this.obstacleWidth[14] = 200;
        this.obstacleHeight[14] = 40;
        this.direction[14] = true;
        this.obstacleX[15] = 280;
        this.obstacleY[15] = 1415;
        this.obstacleWidth[15] = 400;
        this.obstacleHeight[15] = 40;
        this.direction[15] = true;
        this.obstacleX[16] = 680;
        this.obstacleY[16] = 1415;
        this.obstacleWidth[16] = 200;
        this.obstacleHeight[16] = 40;
        this.direction[16] = true;
        this.obstacleX[17] = 880;
        this.obstacleY[17] = 1175;
        this.obstacleWidth[17] = 280;
        this.obstacleHeight[17] = 40;
        this.direction[17] = false;
        this.obstacleX[18] = 880;
        this.obstacleY[18] = 1175;
        this.obstacleWidth[18] = 500;
        this.obstacleHeight[18] = 40;
        this.direction[18] = true;
        this.obstacleX[19] = 1380;
        this.obstacleY[19] = 280;
        this.obstacleWidth[19] = 500;
        this.obstacleHeight[19] = 40;
        this.direction[19] = false;
        this.obstacleX[20] = 1380;
        this.obstacleY[20] = 900;
        this.obstacleWidth[20] = 315;
        this.obstacleHeight[20] = 40;
        this.direction[20] = false;
        this.obstacleX[21] = 1380;
        this.obstacleY[21] = 700;
        this.obstacleWidth[21] = 250;
        this.obstacleHeight[21] = 40;
        this.direction[21] = true;
        this.obstacleX[22] = 1630;
        this.obstacleY[22] = 700;
        this.obstacleWidth[22] = 1000;
        this.obstacleHeight[22] = 40;
        this.direction[22] = false;
        this.obstacleX[23] = 675;
        this.obstacleY[23] = 1700;
        this.obstacleWidth[23] = 1000;
        this.obstacleHeight[23] = 40;
        this.direction[23] = true;
        this.obstacleX[24] = 675;
        this.obstacleY[24] = 1700;
        this.obstacleWidth[24] = 900;
        this.obstacleHeight[24] = 40;
        this.direction[24] = false;
        this.obstacleX[25] = 475;
        this.obstacleY[25] = 1700;
        this.obstacleWidth[25] = 900;
        this.obstacleHeight[25] = 40;
        this.direction[25] = false;
        this.obstacleX[26] = 280;
        this.obstacleY[26] = 1400;
        this.obstacleWidth[26] = 1200;
        this.obstacleHeight[26] = 40;
        this.direction[26] = false;
        this.obstacleX[27] = 280;
        this.obstacleY[27] = 2600;
        this.obstacleWidth[27] = 435;
        this.obstacleHeight[27] = 40;
        this.direction[27] = true;
    }

    public void levelTwo() {
        this.obstacleX[0] = 1300;
        this.obstacleY[0] = 1300;
        this.obstacleWidth[0] = 200;
        this.obstacleHeight[0] = 100;
        this.direction[0] = true;
        this.obstacleX[1] = 1600;
        this.obstacleY[1] = 1600;
        this.obstacleWidth[1] = 1200;
        this.obstacleHeight[1] = 75;
        this.direction[1] = false;
        this.obstacleX[2] = 1200;
        this.obstacleY[2] = 1470;
        this.obstacleWidth[2] = 400;
        this.obstacleHeight[2] = 75;
        this.direction[2] = false;
        this.obstacleX[3] = 500;
        this.obstacleY[3] = 1000;
        this.obstacleWidth[3] = 200;
        this.obstacleHeight[3] = 90;
        this.direction[3] = false;
        this.obstacleX[4] = 800;
        this.obstacleY[4] = 1200;
        this.obstacleWidth[4] = 400;
        this.obstacleHeight[4] = 75;
        this.direction[4] = true;
        this.obstacleX[5] = 600;
        this.obstacleY[5] = 2150;
        this.obstacleWidth[5] = 400;
        this.obstacleHeight[5] = 200;
        this.direction[5] = true;
        this.obstacleX[6] = 2130;
        this.obstacleY[6] = 900;
        this.obstacleWidth[6] = 800;
        this.obstacleHeight[6] = 75;
        this.direction[6] = false;
        this.obstacleX[7] = 2110;
        this.obstacleY[7] = 2500;
        this.obstacleWidth[7] = 300;
        this.obstacleHeight[7] = 75;
        this.direction[7] = false;
        this.obstacleX[8] = 2110;
        this.obstacleY[8] = 2425;
        this.obstacleWidth[8] = 890;
        this.obstacleHeight[8] = 75;
        this.direction[8] = true;
        this.obstacleX[9] = 700;
        this.obstacleY[9] = 100;
        this.obstacleWidth[9] = 670;
        this.obstacleHeight[9] = 75;
        this.direction[9] = false;
        this.obstacleX[10] = 0;
        this.obstacleY[10] = 700;
        this.obstacleWidth[10] = 775;
        this.obstacleHeight[10] = 75;
        this.direction[10] = true;
        this.obstacleX[11] = 1200;
        this.obstacleY[11] = 700;
        this.obstacleWidth[11] = 800;
        this.obstacleHeight[11] = 100;
        this.direction[11] = true;
    }

    private void clearObstacles() {
        Arrays.fill(this.obstacleY, 0);
        Arrays.fill(this.obstacleX, 0);
        Arrays.fill(this.obstacleWidth, 0);
        Arrays.fill(this.obstacleHeight, 0);
    }

    void addEntity(Entity e) {
        this.entities.add(e);
    }

    public boolean isWon() {
        return this.won;
    }

    public static void main(String[] args) {
        new Game();
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private int pressCount = 1;

        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (Game.this.waitingForKeyPress) {
                return;
            }
            if (e.getKeyCode() == 65) {
                Game.this.leftPressed = true;
            }
            if (e.getKeyCode() == 68) {
                Game.this.rightPressed = true;
            }
            if (e.getKeyCode() == 87) {
                Game.this.upPressed = true;
            }
            if (e.getKeyCode() == 83) {
                Game.this.downPressed = true;
            }
            if (e.getKeyCode() == 80) {
                Game.this.time = System.currentTimeMillis();
                Game.this.pPressed = true;
            }
            if (Game.this.pPressed && Game.this.isPaused()) {
                Game.this.setPaused(false);
                Game.this.pPressed = false;
            }
            if (Game.this.pPressed) {
                Game.this.setPaused(true);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (Game.this.waitingForKeyPress) {
                return;
            }
            if (e.getKeyCode() == 65) {
                Game.this.leftPressed = false;
            }
            if (e.getKeyCode() == 83) {
                Game.this.downPressed = false;
            }
            if (e.getKeyCode() == 68) {
                Game.this.rightPressed = false;
            }
            if (e.getKeyCode() == 87) {
                Game.this.upPressed = false;
            }
            if (e.getKeyCode() == 32) {
                Game.this.firePressed = false;
            }
            if (e.getKeyCode() == 80) {
                Game.this.pPressed = false;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (Game.this.waitingForKeyPress) {
                if (this.pressCount == 1) {
                    Game.this.waitingForKeyPress = false;
                    if (Game.this.level == 4) {
                        Game.this.level = 1;
                    }
                    Game.this.startGame();
                    this.pressCount = 0;
                } else {
                    ++this.pressCount;
                }
            }
            if (e.getKeyChar() == '\u001b') {
                Game.this.paused = true;
                state = STATE.MENU;
                drawn = false;
            }
        }
    }

    public class MouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            Game.this.setMouseX(e.getX());
            Game.this.setMouseY(e.getY());
            if (SwingUtilities.isRightMouseButton(e) && Game.this.getWeapons() == 3) {
                Game.this.panning = true;
                double vx = Game.this.getMouseX() - (Game.this.ship.getX() - Game.this.cameraX);
                double vy = Game.this.getMouseY() - (Game.this.ship.getY() - Game.this.cameraY);
                double angle = Math.atan2(vy, vx);
                Game.this.panOffsetX = Math.cos(angle) * 500.0;
                Game.this.panOffsetY = Math.sin(angle) * 500.0;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (state == STATE.GAME) {
                if (SwingUtilities.isRightMouseButton(e) && Game.this.getWeapons() == 3) {
                    Game.this.panning = false;
                    Game.this.panOffsetX = 0.0;
                    Game.this.panOffsetY = 0.0;
                } else {
                    Game.this.firePressed = true;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Game.this.setMouseX(e.getX());
            Game.this.setMouseY(e.getY());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Game.this.setMouseX(e.getX());
            Game.this.setMouseY(e.getY());
        }
    }

    public static enum STATE {
        MENU,
        GAME;

    }
}

