/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;

public abstract class Entity {
    protected double x;
    protected double y;
    protected Sprite sprite;
    protected double dx;
    protected double dy;
    protected Game game;
    private Rectangle me = new Rectangle();
    private Rectangle him = new Rectangle();

    public Entity(Game g, String r, int newX, int newY) {
        this.x = newX;
        this.y = newY;
        this.game = g;
        this.sprite = SpriteStore.get().getSprite(r);
    }

    public void move(long delta) {
        this.x += (double)delta * this.dx / 1000.0;
        this.y += (double)delta * this.dy / 1000.0;
    }

    public double moveX(long delta) {
        return this.x += (double)delta * this.dx / 1000.0;
    }

    public double moveY(long delta) {
        return this.y += (double)delta * this.dy / 1000.0;
    }

    public void setHorizontalMovement(double newDX) {
        this.dx = newDX;
    }

    public void setVerticalMovement(double newDY) {
        this.dy = newDY;
    }

    public double getHorizontalMovement() {
        return this.dx;
    }

    public double getVerticalMovement() {
        return this.dy;
    }

    public int getX() {
        return (int)this.x;
    }

    public int getY() {
        return (int)this.y;
    }

    public void draw(Graphics2D g) {
        this.sprite.draw(g, (int)this.x, (int)this.y);
    }

    public Polygon getZone() {
        return null;
    }

    public void doLogic() {
    }

    public boolean collidesWith(Entity other) {
        if (other instanceof AlienEntity) {
            this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
            this.him.setBounds(other.getX() + this.game.getCameraX(), other.getY() + this.game.getCameraY(), 100, 150);
        } else if (other instanceof ShotEntity) {
            this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
            this.him.setBounds(other.getX() + this.game.getCameraX(), other.getY() + this.game.getCameraY(), other.sprite.getWidth(), other.sprite.getHeight());
        } else {
            this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
            this.him.setBounds(other.getX(), other.getY(), other.sprite.getWidth(), other.sprite.getHeight());
        }
        return this.me.intersects(this.him);
    }

    public void collidedWith() {
    }

    public abstract void collidedWith(Entity var1);

    public Polygon drawVisionTriangle(Entity o, int i, double j) {
        Polygon Polygon2 = null;
        return Polygon2;
    }

    public void setZone(Entity alien, int view) {
    }

    public void draw(Graphics g, int cameraX, int cameraY, int screenWidth, int screenHeight) {
    }

    public void setSprite(String newSprite) {
        this.sprite = SpriteStore.get().getSprite(newSprite);
    }

    public Rectangle getMe() {
        return this.me;
    }

    public void drawHitbox(Graphics2D g) {
        g.drawRect((int)(this.x + (double)this.game.getCameraX()), (int)(this.y + (double)this.game.getCameraY()), this.sprite.getWidth(), this.sprite.getHeight());
    }

    public void draw(Graphics2D g, int cameraX, int cameraY, int screenWidth, int screenHeight) {
    }
}

