/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

public class AlienEntity
extends Entity {
    private double moveSpeed = 150.0;
    private double smoothAngle = 0.0;
    private Game game;
    private Polygon collisionZone;
    private double angle;
    private int endX;
    private int endY;
    private int startX;
    private int startY;
    private Rectangle me = new Rectangle();
    private Rectangle him = new Rectangle();
    public int randomAngle = (int)(Math.random() * 270.0);
    public double randomFrequency = Math.random() * 2.2 + 0.5;
    private long time = System.currentTimeMillis();

    public AlienEntity(Game g, String r, int newX, int newY, int rotate, int endX, int endY) {
        super(g, r, newX, newY);
        this.game = g;
        this.collisionZone = this.drawVisionTriangle(1, 0.0);
        this.startX = newX;
        this.startY = newY;
        this.endX = endX;
        this.endY = endY;
        double vx = this.endX - this.startX;
        double vy = this.endY - this.startY;
        double hyp = Math.hypot(vx, vy);
        if (hyp == 0.0) {
            this.dx = 0.0;
            this.dy = -this.moveSpeed;
            return;
        }
        this.dx = vx / hyp * this.moveSpeed;
        this.dy = vy / hyp * this.moveSpeed;
    }

    @Override
    public void move(long delta) {
        if (!this.game.isPaused()) {
            double nextX = this.x + this.dx * (double)delta / 1000.0;
            double nextY = this.y + this.dy * (double)delta / 1000.0;
            double elapsed = (double)(System.currentTimeMillis() - this.time) / 1000.0;
            this.smoothAngle = Math.sin(elapsed / this.randomFrequency) * 90.0 + (double)this.randomAngle;
            double toEndBefore = Math.hypot((double)this.endX - this.x, (double)this.endY - this.y);
            double toEndAfter = Math.hypot((double)this.endX - nextX, (double)this.endY - nextY);
            if (this.startX != this.endX || this.startY != this.endY) {
                if (toEndAfter > toEndBefore) {
                    this.x = this.endX;
                    this.y = this.endY;
                    int temp = this.startX;
                    this.startX = this.endX;
                    this.endX = temp;
                    temp = this.startY;
                    this.startY = this.endY;
                    this.endY = temp;
                    this.doLogic();
                    this.collisionZone = this.drawVisionTriangle(1, this.smoothAngle);
                } else {
                    super.move(delta);
                    this.collisionZone = this.drawVisionTriangle(1, this.smoothAngle);
                }
            } else {
                this.collisionZone = this.drawVisionTriangle(1, this.smoothAngle);
            }
        }
    }

    @Override
    public Polygon getZone() {
        return this.collisionZone;
    }

    public Polygon drawVisionTriangle(int scale, double angleDegrees) {
        double ax = this.x;
        double ay = this.y;
        int visionDistance = scale * 200;
        double[] baseX = new double[]{ax, ax - 100.0, ax + 100.0};
        double[] baseY = new double[]{ay, ay + (double)visionDistance, ay + (double)visionDistance};
        double theta = Math.toRadians(angleDegrees);
        int[] xRot = new int[3];
        int[] yRot = new int[3];
        int i = 0;
        while (i < 3) {
            double relX = baseX[i] - ax;
            double relY = baseY[i] - ay;
            double rotX = relX * Math.cos(theta) - relY * Math.sin(theta);
            double rotY = relX * Math.sin(theta) + relY * Math.cos(theta);
            xRot[i] = (int)(rotX + ax);
            yRot[i] = (int)(rotY + ay);
            ++i;
        }
        return new Polygon(xRot, yRot, 3);
    }

    public void drawAlien(Graphics2D g, int cameraX, int cameraY, int screenWidth, int screenHeight) {
        boolean onScreen;
        int spriteWidth = 150;
        int spriteHeight = 100;
        int drawX = (int)this.x - spriteWidth / 2;
        int drawY = (int)this.y - spriteHeight / 2;
        boolean bl = onScreen = drawX + spriteWidth > cameraX && drawX < cameraX + screenWidth && drawY + spriteHeight > cameraY && drawY < cameraY + screenHeight;
        if (!onScreen) {
            return;
        }
        int screenX = drawX - cameraX;
        int screenY = drawY - cameraY;
        this.angle = this.getMovementAngleDegrees();
        AffineTransform old = g.getTransform();
        g.translate(screenX + spriteWidth / 2, screenY + spriteHeight / 2);
        g.rotate(Math.toRadians(this.angle) + 1.5707963267948966);
        this.sprite.draw(g, -50, -75, 100, 150);
        g.setTransform(old);
        Polygon zone = this.collisionZone;
        if (zone != null) {
            Polygon shifted = new Polygon();
            int i = 0;
            while (i < zone.npoints) {
                shifted.addPoint(zone.xpoints[i] - cameraX, zone.ypoints[i] - cameraY);
                ++i;
            }
            g.setColor(new Color(255, 255, 255, 100));
            g.fillPolygon(shifted);
            g.setColor(Color.WHITE);
            g.drawPolygon(shifted);
        }
    }

    @Override
    public void doLogic() {
        this.dx *= -1.0;
        this.dy *= -1.0;
    }

    @Override
    public boolean collidesWith(Entity other) {
        this.him.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
        this.me.setBounds(other.getX() + this.game.getCameraX(), other.getY() + this.game.getCameraY(), 125, 75);
        return this.me.intersects(this.him);
    }

    private double getMovementAngleDegrees() {
        return Math.toDegrees(Math.atan2(this.dy, this.dx));
    }

    @Override
    public void collidedWith(Entity other) {
    }

    public double getAngle() {
        return this.angle;
    }
}

