/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

public class AlienDestroyed
extends Entity {
    private Game game;
    private String[] explosionSprites = new String[]{"sprites/explosion1.png", "sprites/explosion2.png", "sprites/explosion3.png", "sprites/explosion4.png", "sprites/explosion5.png", "sprites/explosion6.png", "sprites/explosion7.png"};
    private List<Explosion> explosions = new ArrayList<Explosion>();
    private double angle;

    public AlienDestroyed(Game g, String r, int newX, int newY, double angle) {
        super(g, r, newX, newY);
        this.game = g;
        this.angle = angle;
        this.explosions();
    }

    @Override
    public void move(long delta) {
        if (!this.game.isPaused()) {
            ArrayList<Explosion> finished = new ArrayList<Explosion>();
            for (Explosion e : this.explosions) {
                e.frameIndex += e.fps * ((double)delta / 1250.0);
                if (!e.isFinished()) continue;
                finished.add(e);
            }
            this.explosions.removeAll(finished);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        AffineTransform old = g.getTransform();
        int drawX = (int)(this.x - (double)this.game.getCameraX());
        int drawY = (int)(this.y - (double)this.game.getCameraY());
        int centerX = drawX + 24;
        int centerY = drawY + 39;
        g.rotate(this.angle, centerX, centerY);
        this.sprite.draw(g, drawX, drawY, 125, 175);
        for (Explosion e : this.explosions) {
            int frame = (int)Math.floor(e.frameIndex);
            frame = Math.max(0, Math.min(frame, e.frames.length - 1));
            Sprite s = e.frames[frame];
            int ex = centerX + (int)e.xOffset;
            int ey = centerY + (int)e.yOffset;
            s.draw(g, ex, ey, 80, 80);
        }
        g.setTransform(old);
    }

    public void explosions() {
        int count = 3 + (int)(Math.random() * 4.0);
        int i = 0;
        while (i < count) {
            Sprite[] frames = new Sprite[this.explosionSprites.length];
            int f = 0;
            while (f < this.explosionSprites.length) {
                frames[f] = SpriteStore.get().getSprite(this.explosionSprites[f]);
                ++f;
            }
            double xOff = -40.0 + Math.random() * 80.0;
            double yOff = -60.0 + Math.random() * 120.0;
            double fps = 5.0 + Math.random() * 10.0;
            this.explosions.add(new Explosion(frames, xOff, yOff, fps));
            ++i;
        }
    }

    @Override
    public void collidedWith(Entity other) {
    }

    @Override
    public void doLogic() {
        this.dx *= -1.0;
        this.dy *= -1.0;
    }

    private static class Explosion {
        public Sprite[] frames;
        public double frameIndex = 0.0;
        public double fps;
        public double xOffset;
        public double yOffset;

        public Explosion(Sprite[] f, double xOff, double yOff, double fps) {
            this.frames = f;
            this.xOffset = xOff;
            this.yOffset = yOff;
            this.fps = fps;
        }

        public boolean isFinished() {
            return this.frameIndex >= (double)this.frames.length;
        }
    }
}

