/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Game
extends Canvas {
    final double G = 9.8;
    private int level = 0;
    private int[][] tiles = new int[40][32];
    private ArrayList<Walls> walls = new ArrayList();
    private ArrayList<Exit> exit = new ArrayList();
    private ArrayList<Spike> spikes = new ArrayList();
    private ArrayList<Chaser> chasers = new ArrayList();
    private BufferStrategy strategy;
    private boolean waitingForKeyPress = true;
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    private boolean upPressed = false;
    private boolean isPaused = false;
    private boolean gameRunning = true;
    private ArrayList<Entity> entities = new ArrayList();
    private ArrayList<Entity> removeEntities = new ArrayList();
    private Entity ship;
    private double shipSpeed = 20.0;
    private String message = "";
    private boolean logicRequiredThisLoop = false;
    private int timeFalling = 0;
    private int timeStrafing = 0;
    public boolean onWall = false;
    public boolean hittingWall = false;
    public final int GAMEWIDTH = 1000;
    public final int GAMEHEIGHT = 800;
    private static final double BOUNCINESS = 1.3;
    private Background background = new Background();

    public Game() {
        JFrame container = new JFrame("Drone Dash");
        JPanel panel = (JPanel)container.getContentPane();
        panel.setPreferredSize(new Dimension(1000, 800));
        panel.setLayout(null);
        this.setBounds(0, 0, 1000, 800);
        panel.add(this);
        this.setIgnoreRepaint(true);
        container.pack();
        container.setResizable(false);
        container.setVisible(true);
        container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(new KeyInputHandler());
        this.requestFocus();
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
        this.initEntities();
        this.gameLoop();
    }

    private void initEntities() {
        this.ship = new ShipEntity(this, "sprites/ship.png", 50, 725);
        this.entities.add(this.ship);
        String[] fileContents = null;
        try {
            fileContents = Game.getFileContents("level" + this.level + ".txt");
        }
        catch (Exception e) {
            System.exit(0);
        }
        int x = 0;
        while (x < 40) {
            int y = 0;
            while (y < 32) {
                this.tiles[x][y] = fileContents[y].charAt(x) == 'w' ? 99 : (fileContents[y].charAt(x) == 'd' ? 98 : (fileContents[y].charAt(x) == 's' ? 97 : (fileContents[y].charAt(x) == 'a' ? 96 : Character.getNumericValue(fileContents[y].charAt(x)))));
                ++y;
            }
            ++x;
        }
        int y = 0;
        while (y < 32) {
            int x2 = 0;
            while (x2 < 40) {
                Spike spike;
                if (this.tiles[x2][y] == 1) {
                    Walls wall = new Walls(x2 * 25, y * 25);
                    this.walls.add(wall);
                }
                if (this.tiles[x2][y] == 99) {
                    spike = new Spike(this, x2 * 25, y * 25, "Up");
                    this.spikes.add(spike);
                }
                if (this.tiles[x2][y] == 98) {
                    spike = new Spike(this, x2 * 25, y * 25, "Right");
                    this.spikes.add(spike);
                }
                if (this.tiles[x2][y] == 97) {
                    spike = new Spike(this, x2 * 25, y * 25, "Down");
                    this.spikes.add(spike);
                }
                if (this.tiles[x2][y] == 96) {
                    spike = new Spike(this, x2 * 25, y * 25, "Left");
                    this.spikes.add(spike);
                }
                if (this.tiles[x2][y] == 4) {
                    Chaser chaser = new Chaser(x2 * 25, y * 25);
                    this.chasers.add(chaser);
                }
                if (this.tiles[x2][y] == 9) {
                    Exit exit = new Exit(x2 * 25, y * 25);
                    this.exit.add(exit);
                }
                ++x2;
            }
            ++y;
        }
    }

    public void updateLogic() {
        this.logicRequiredThisLoop = true;
    }

    public void removeEntity(Entity entity) {
        this.removeEntities.add(entity);
    }

    public void notifyDeath() {
        this.message = "You died! Try again?";
        this.waitingForKeyPress = true;
    }

    public void notifyWin() {
        this.message = "You win! Try again?";
        this.waitingForKeyPress = true;
    }

    public void gameLoop() {
        long lastLoopTime = System.currentTimeMillis();
        boolean check = true;
        while (this.gameRunning) {
            long delta = System.currentTimeMillis() - lastLoopTime;
            lastLoopTime = System.currentTimeMillis();
            Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
            g.setColor(Color.black);
            g.fillRect(0, 0, 1000, 800);
            this.background.draw(g);
            double deltaSeconds = (double)delta / 1000.0;
            double dx = this.ship.dx * deltaSeconds;
            double dy = this.ship.dy * deltaSeconds;
            if (!this.waitingForKeyPress && !this.isPaused) {
                Rectangle exi;
                int pLevel;
                Entity player = this.entities.get(0);
                this.hittingWall = false;
                this.onWall = false;
                if (dx != 0.0) {
                    Rectangle futureH = new Rectangle((int)(player.x + dx), (int)player.y, 25, 25);
                    pLevel = this.level;
                    for (Exit e : this.exit) {
                        exi = e.hitBox();
                        if (!futureH.intersects(exi)) continue;
                        ++this.level;
                        if (this.level != 8) break;
                        this.notifyWin();
                        this.level = 0;
                        break;
                    }
                    for (Spike spike : this.spikes) {
                        Rectangle s = spike.hitBox();
                        if (!futureH.intersects(s)) continue;
                        this.notifyDeath();
                    }
                    if (this.level > pLevel) {
                        this.startGame();
                    }
                    for (Walls wall : this.walls) {
                        Rectangle w = wall.hitBox();
                        if (!futureH.intersects(w)) continue;
                        player.x = dx > 0.0 ? (double)(w.x - 25) : (double)(w.x + w.width);
                        player.dx = 0.0;
                        this.hittingWall = true;
                        dx = 0.0;
                        break;
                    }
                }
                if (!this.hittingWall) {
                    player.x += dx;
                }
                if (dy != 0.0) {
                    Rectangle futureV = new Rectangle((int)player.x, (int)(player.y + dy), 25, 25);
                    pLevel = this.level;
                    for (Exit e : this.exit) {
                        exi = e.hitBox();
                        if (!futureV.intersects(exi)) continue;
                        ++this.level;
                        if (this.level != 8) break;
                        this.notifyWin();
                        this.level = 0;
                        break;
                    }
                    if (this.level > pLevel) {
                        this.startGame();
                    }
                    int wall = 0;
                    while (wall < this.walls.size()) {
                        Rectangle w = this.walls.get(wall).hitBox();
                        if (futureV.intersects(w)) {
                            if (dy > 0.0) {
                                player.y = w.y - 25;
                                this.onWall = true;
                                dy = 0.0;
                                this.timeFalling = 0;
                            } else {
                                player.y = w.y + w.height;
                                this.timeFalling = (int)((double)this.timeFalling / -1.3);
                            }
                            dy = 0.0;
                            break;
                        }
                        ++wall;
                    }
                }
                player.y += dy;
                int worldW = 1000;
                int worldH = 800;
                if (player.x < 0.0) {
                    player.x = 0.0;
                    player.dx = 0.0;
                } else if (player.x > (double)(worldW - 25)) {
                    player.x = worldW - 25;
                    player.dx = 0.0;
                }
                if (player.y < 0.0) {
                    player.y = 0.0;
                    player.dy = 0.0;
                } else if (player.y > (double)(worldH - 25)) {
                    player.y = worldH - 25;
                    player.dy = 0.0;
                    this.timeFalling = 0;
                    this.onWall = true;
                }
                int i = 0;
                while (i < this.chasers.size()) {
                    double cX = this.chasers.get(i).getX();
                    double cY = this.chasers.get(i).getY();
                    Rectangle p = new Rectangle((int)cX, (int)cY, 25, 25);
                    Rectangle c = new Rectangle((int)player.x, (int)player.y, 25, 25);
                    double xDist = cX - (double)player.getX();
                    double yDist = cY - (double)player.getY();
                    if (Math.abs(xDist) < 800.0 && Math.abs(yDist) < 800.0) {
                        this.chasers.get(i).signal(player.getX(), player.getY());
                    } else {
                        this.chasers.get(i).drift();
                    }
                    if (p.intersects(c)) {
                        this.notifyDeath();
                    }
                    ++i;
                }
                i = 1;
                while (i < this.entities.size()) {
                    this.entities.get(i).move(delta);
                    ++i;
                }
            } else if (this.waitingForKeyPress) {
                this.reset();
                if (this.level == 3 && check) {
                    this.ship.x = 100.0;
                    this.ship.y = 200.0;
                    check = false;
                }
            }
            int i = 0;
            while (i < this.entities.size()) {
                Entity entity = this.entities.get(i);
                entity.draw(g);
                ++i;
            }
            i = 0;
            while (i < this.walls.size()) {
                Walls wall = this.walls.get(i);
                wall.draw(g);
                ++i;
            }
            i = 0;
            while (i < this.exit.size()) {
                Exit e = this.exit.get(i);
                e.draw(g);
                ++i;
            }
            i = 0;
            while (i < this.spikes.size()) {
                Spike s = this.spikes.get(i);
                s.draw(g);
                ++i;
            }
            i = 0;
            while (i < this.chasers.size()) {
                Chaser c = this.chasers.get(i);
                c.draw(g);
                ++i;
            }
            i = 0;
            while (i < this.entities.size()) {
                int j = i + 1;
                while (j < this.entities.size()) {
                    Entity him;
                    Entity me = this.entities.get(i);
                    if (me.collidesWith(him = this.entities.get(j))) {
                        me.collidedWith(him);
                        him.collidedWith(me);
                    }
                    ++j;
                }
                ++i;
            }
            this.entities.removeAll(this.removeEntities);
            this.removeEntities.clear();
            if (this.logicRequiredThisLoop) {
                i = 0;
                while (i < this.entities.size()) {
                    Entity entity = this.entities.get(i);
                    entity.doLogic();
                    ++i;
                }
                this.logicRequiredThisLoop = false;
            }
            if (this.waitingForKeyPress) {
                g.setColor(Color.white);
                g.drawString(this.message, (1000 - g.getFontMetrics().stringWidth(this.message)) / 2, 350);
                g.drawString("Press any key", (1000 - g.getFontMetrics().stringWidth("Press any key")) / 2, 400);
            }
            g.dispose();
            this.strategy.show();
            if (this.leftPressed && !this.rightPressed) {
                --this.timeStrafing;
            } else if (this.rightPressed && !this.leftPressed) {
                ++this.timeStrafing;
            }
            if (this.ship.x + dx < 0.0) {
                this.ship.x = 0.0;
                this.timeStrafing = (int)((double)this.timeStrafing / -1.3);
            } else if (this.ship.x + dx > 975.0) {
                this.ship.x = 975.0;
                this.timeStrafing = (int)((double)this.timeStrafing / -1.3);
            }
            if (this.ship.y <= 0.0) {
                this.ship.y = 1.0;
                this.timeFalling = (int)((double)this.timeFalling / -1.3);
            } else if (this.ship.y + dy > 750.0) {
                this.ship.y = 749.0;
                this.timeFalling = (int)((double)this.timeFalling / -1.3);
            }
            if (this.hittingWall) {
                this.timeStrafing = (int)((double)this.timeStrafing / -1.3);
            }
            if (this.hittingWall && this.onWall) {
                this.timeFalling = (int)((double)this.timeFalling / -1.3);
            }
            this.ship.setHorizontalMovement(this.shipSpeed * 9.8 * ((double)this.timeStrafing / 1000.0));
            if (!this.upPressed && this.ship.y < 750.0) {
                ++this.timeFalling;
                this.ship.setVerticalMovement(this.shipSpeed * 9.8 * ((double)this.timeFalling / 1000.0));
            } else if (this.upPressed && this.ship.y > 0.0) {
                this.ship.setVerticalMovement(-(this.shipSpeed * 9.8 * ((double)(-this.timeFalling) / 1000.0)));
                --this.timeFalling;
            }
            if (this.level != 3 || !check) continue;
            this.ship.x = 100.0;
            this.ship.y = 200.0;
            check = false;
        }
    }

    private void reset() {
        this.entities.clear();
        this.walls.clear();
        this.exit.clear();
        this.spikes.clear();
        this.chasers.clear();
        this.ship.dx = 0.0;
        this.ship.dy = 0.0;
        this.upPressed = false;
        this.rightPressed = false;
        this.leftPressed = false;
        this.timeFalling = 0;
        this.timeStrafing = 0;
    }

    private void startGame() {
        this.reset();
        this.initEntities();
        this.leftPressed = false;
        this.rightPressed = false;
        this.isPaused = false;
    }

    public static void main(String[] args) {
        new Game();
    }

    public static String[] getFileContents(String fileName) {
        String[] contents = null;
        int length = 0;
        try {
            String folderName = "/subFolder/";
            String resource = fileName;
            InputStream input = Game.class.getResourceAsStream(String.valueOf(folderName) + resource);
            if (input == null) {
                input = Game.class.getClassLoader().getResourceAsStream(resource);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            in.mark(Short.MAX_VALUE);
            while (in.readLine() != null) {
                ++length;
            }
            in.reset();
            contents = new String[length];
            int i = 0;
            while (i < length) {
                contents[i] = in.readLine();
                ++i;
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println("File Input Error");
        }
        return contents;
    }

    public static void writeArrayToFile(String fileName, String[] a) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter writer = new FileWriter(fileName);){
                String[] stringArray = a;
                int n = a.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    writer.write(String.valueOf(line) + "\n");
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("File Write Error");
            e.printStackTrace();
        }
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private int pressCount = 1;

        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (Game.this.waitingForKeyPress) {
                return;
            }
            if (e.getKeyCode() == 37 || e.getKeyCode() == 65) {
                Game.this.leftPressed = true;
            }
            if (e.getKeyCode() == 39 || e.getKeyCode() == 68) {
                Game.this.rightPressed = true;
            }
            if (e.getKeyCode() == 38 || e.getKeyCode() == 87) {
                Game.this.upPressed = true;
            }
            if (e.getKeyCode() == 80) {
                Game.this.isPaused = !Game.this.isPaused;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (Game.this.waitingForKeyPress) {
                return;
            }
            if (e.getKeyCode() == 37 || e.getKeyCode() == 65) {
                Game.this.leftPressed = false;
            }
            if (e.getKeyCode() == 39 || e.getKeyCode() == 68) {
                Game.this.rightPressed = false;
            }
            if (e.getKeyCode() == 38 || e.getKeyCode() == 87) {
                Game.this.upPressed = false;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (Game.this.waitingForKeyPress) {
                if (this.pressCount == 1) {
                    Game.this.waitingForKeyPress = false;
                    Game.this.startGame();
                    this.pressCount = 0;
                } else {
                    ++this.pressCount;
                }
            }
            if (e.getKeyChar() == '\u001b') {
                System.exit(0);
            }
        }
    }
}

