/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class bgm {
    private static final int BUFFER_SIZE = 4096;
    private AudioInputStream[] streams;
    private SourceDataLine line;
    private boolean[] activeTrack;
    private boolean running = true;
    private int numTracks;
    private ArrayList<String> Slist = new ArrayList();
    private int volume = 5;

    public bgm() {
        this.Slist.add("sounds/bgm0.wav");
        this.Slist.add("sounds/bgm1.wav");
        this.Slist.add("sounds/bgm5.wav");
        this.Slist.add("sounds/bgm10.wav");
        this.Slist.add("sounds/bgm20.wav");
        this.Slist.add("sounds/bgm50.wav");
        this.numTracks = this.Slist.size();
        this.streams = new AudioInputStream[this.numTracks];
        this.activeTrack = new boolean[this.numTracks];
        try {
            int i = 0;
            while (i < this.numTracks) {
                URL url = this.getClass().getClassLoader().getResource(this.Slist.get(i));
                if (url == null) {
                    throw new RuntimeException("Cannot find resource: " + this.Slist.get(i));
                }
                AudioInputStream original = AudioSystem.getAudioInputStream(url);
                AudioFormat base = original.getFormat();
                AudioFormat target = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, base.getSampleRate(), 16, base.getChannels(), base.getChannels() * 2, base.getSampleRate(), false);
                this.streams[i] = AudioSystem.getAudioInputStream(target, original);
                ++i;
            }
            AudioFormat format = this.streams[0].getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(format);
            this.line.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Thread t = new Thread(this::streamLoop);
        t.setDaemon(true);
        t.start();
        int i = 0;
        while (i < this.numTracks) {
            this.setActiveTrack(i);
            ++i;
        }
        this.setActiveTrack(0);
    }

    private void streamLoop() {
        byte[] buffer = new byte[4096];
        while (this.running) {
            int i = 0;
            while (i < this.numTracks) {
                if (this.activeTrack[i]) {
                    try {
                        int bytesRead = this.streams[i].read(buffer, 0, 4096);
                        if (bytesRead == -1) {
                            this.streams[i].close();
                            URL url = this.getClass().getClassLoader().getResource(this.Slist.get(i));
                            AudioInputStream original = AudioSystem.getAudioInputStream(url);
                            AudioFormat base = original.getFormat();
                            AudioFormat target = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, base.getSampleRate(), 16, base.getChannels(), base.getChannels() * 2, base.getSampleRate(), false);
                            this.streams[i] = AudioSystem.getAudioInputStream(target, original);
                            bytesRead = this.streams[i].read(buffer, 0, 4096);
                        }
                        if (bytesRead > 0) {
                            this.applyVolume(buffer, bytesRead);
                            this.line.write(buffer, 0, bytesRead);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
    }

    private void applyVolume(byte[] buf, int len) {
        float mul = (float)this.volume / 10.0f;
        int i = 0;
        while (i < len - 1) {
            int sample = buf[i + 1] << 8 | buf[i] & 0xFF;
            sample = (int)((float)sample * mul);
            buf[i] = (byte)(sample & 0xFF);
            buf[i + 1] = (byte)(sample >> 8 & 0xFF);
            i += 2;
        }
    }

    public void setVolume(int v) {
        this.volume = v;
    }

    public void setActiveTrack(int index) {
        int i = 0;
        while (i < this.activeTrack.length) {
            this.activeTrack[i] = i == index;
            ++i;
        }
    }

    public void stopAll() {
        this.running = false;
        if (this.line != null) {
            this.line.stop();
            this.line.close();
        }
        AudioInputStream[] audioInputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            AudioInputStream stream = audioInputStreamArray[n2];
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
    }
}

