/*
 * Decompiled with CFR 0.152.
 */
public class ShotEntity
extends Entity {
    private double MSY;
    private int used = 0;
    private Game game;
    private int type;
    private String r;
    private long spintime = 0L;
    private boolean spin = false;
    private Sprite a1 = SpriteStore.get().getSprite("sprites/shot1/shot1a.png");
    private Sprite a2 = SpriteStore.get().getSprite("sprites/shot1/shot1b.png");
    private Sprite b1 = SpriteStore.get().getSprite("sprites/shot2/shot2a.png");
    private Sprite b2 = SpriteStore.get().getSprite("sprites/shot2/shot2b.png");

    public ShotEntity(Game g, String r, int newX, int newY, int used, int MSY, int MSX, int type) {
        super(r, newX, newY);
        this.game = g;
        this.dy = MSY;
        this.dx = MSX;
        this.used = used;
        this.type = type;
        if (this.dy == 0.0 && this.dx == 0.0) {
            this.game.removeEntity(this);
        }
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (this.y < -100.0) {
            this.game.removeEntity(this);
        }
        if (this.y > 1100.0) {
            this.game.removeEntity(this);
        }
        if (this.x < -100.0) {
            this.game.removeEntity(this);
        }
        if (this.x > 1100.0) {
            this.game.removeEntity(this);
        }
        this.spintime += delta / 1000000L;
        if (this.spintime > 100L) {
            this.spin = !this.spin;
            this.spintime = 0L;
            if (this.spin) {
                if (this.type == 0) {
                    this.setSprite(this.a1);
                } else {
                    this.setSprite(this.b1);
                }
            } else if (this.type == 0) {
                this.setSprite(this.a2);
            } else {
                this.setSprite(this.b2);
            }
        }
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof Tile) {
            this.game.removeEntity(other);
            this.game.removeEntity(this);
        }
    }
}

