/*
 * Decompiled with CFR 0.152.
 */
public class ShipEntity
extends Entity {
    private Game game;
    private int hp;
    private int state;

    public ShipEntity(Game g, String r, int newX, int newY, int hp) {
        super(r, newX, newY);
        this.hp = hp;
        this.game = g;
    }

    @Override
    public void move(long delta) {
        if (this.x > 990.0) {
            this.x = 990.0;
            this.dx = 0.0;
        } else if (this.x < 0.0) {
            this.x = 0.0;
            this.dx = 0.0;
        }
        if (this.y > 990.0) {
            this.y = 990.0;
            this.dy = 0.0;
        } else if (this.y < 0.0) {
            this.y = 0.0;
            this.dy = 0.0;
        }
        this.state = this.dx == 0.0 ? 0 : (this.dx < 0.0 ? 1 : 2);
        super.move(delta);
    }

    public int getHP() {
        return this.hp;
    }

    public void hit() {
        this.hp = this.game.getcombo() / 5 == 0 ? --this.hp : (this.hp -= this.game.getcombo() / 5);
        if (this.hp <= 0) {
            this.game.notifyDeath();
        }
    }

    public void heal() {
        ++this.hp;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collidedWith(Entity other) {
        Entity entity = other;
        if (entity instanceof ShotEntity) {
            void shot;
            ShotEntity shotEntity = (ShotEntity)entity;
            ShotEntity cfr_ignored_0 = (ShotEntity)entity;
            if (shot.getType() == 1) {
                this.hit();
                this.game.decombo();
                this.game.removeEntity(other);
            }
        }
        if (other instanceof alien1 || other instanceof alien2) {
            this.hit();
            this.game.alienDead();
            this.game.decombo();
            this.game.removeEntity(other);
        }
        if (other instanceof Tile) {
            double XO = Math.min(this.x, (double)other.getX()) - Math.max(this.x, (double)other.getX()) + 10.0;
            double YO = Math.min(this.y, (double)other.getY()) - Math.max(this.y, (double)other.getY()) + 10.0;
            if (this.x < (double)other.getX() && this.dx > 0.0) {
                this.x -= 1.1 * XO;
            } else if (this.x > (double)other.getX() && this.dx < 0.0) {
                this.x += 1.1 * XO;
            }
            if (this.y < (double)other.getY() && this.dy > 0.0) {
                this.y -= 1.1 * YO;
            } else if (this.y > (double)other.getY() && this.dy < 0.0) {
                this.y += 1.1 * YO;
            }
            this.game.updateshipsprite();
        }
    }

    public int getstate() {
        return this.state;
    }
}

