/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Game
extends Canvas {
    private BufferStrategy strategy;
    private boolean waitingForKeyPress = true;
    private Sprite heart = SpriteStore.get().getSprite("sprites/heart.png");
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    private boolean firePressed = false;
    private boolean jumpPressed = false;
    private boolean downpressed = false;
    private boolean temp = false;
    private boolean debug = false;
    private int best = this.getScore();
    private final int tileSize = 10;
    private int tutorial = 0;
    private boolean gameRunning = true;
    public ArrayList<Entity> entities = new ArrayList();
    public ArrayList<Tile> tiles = new ArrayList();
    private final ArrayList<Entity> removeEntities = new ArrayList();
    private ShipEntity ship;
    private double moveSpeed = 500.0;
    private long lastFire = 0L;
    private long firingInterval = 100L;
    private int shadowtime = 0;
    private int round = 1;
    private int alienN = 1;
    private int count = 0;
    private int combocount;
    private int combo;
    private long lasttime = 0L;
    private static final Path SAVE_FILE = Paths.get(System.getProperty("user.dir"), "save", "hs.txt");
    private Font f = new Font("arial", 1, 12);
    private Sprite bg = SpriteStore.get().getSprite("sprites/bg.png");
    private Sprite combo0 = SpriteStore.get().getSprite("sprites/combo0.png");
    private Sprite combo1 = SpriteStore.get().getSprite("sprites/combo1.png");
    private Sprite combo2 = SpriteStore.get().getSprite("sprites/combo2.png");
    private Sprite combo3 = SpriteStore.get().getSprite("sprites/combo3.png");
    private Sprite combo5 = SpriteStore.get().getSprite("sprites/combo5.png");
    private Sprite combo10 = SpriteStore.get().getSprite("sprites/combo10.png");
    private Sprite combo20 = SpriteStore.get().getSprite("sprites/combo20.png");
    private Sprite combo50 = SpriteStore.get().getSprite("sprites/combo50.png");
    private Sprite title = SpriteStore.get().getSprite("sprites/titleCard.png");
    private Sprite tutorial1 = SpriteStore.get().getSprite("sprites/tutorial1.png");
    private Sprite tutorial2 = SpriteStore.get().getSprite("sprites/tutorial2.png");
    private Color CLEAR = new Color(0, 0, 0, 0);
    private Color tShadow = new Color(20, 20, 50, 100);
    private Color ShadowColor = new Color(20, 20, 50);
    private AffineTransform at = AffineTransform.getScaleInstance(5.0, 5.0);
    private AffineTransform bt = AffineTransform.getScaleInstance(2.0, 2.0);
    BufferedImage shadowspace = new BufferedImage(200, 200, 2);
    BufferedImage textspace = new BufferedImage(500, 500, 2);
    private int[] alienSpawners = new int[4];
    private boolean logicRequiredThisLoop = false;
    private sfx combo1asfx = new sfx("sounds/combosfx1a.wav");
    private sfx combo1bsfx = new sfx("sounds/combosfx1b.wav");
    private sfx combo1csfx = new sfx("sounds/combosfx1c.wav");
    private sfx combo2asfx = new sfx("sounds/combosfx2a.wav");
    private sfx combo2bsfx = new sfx("sounds/combosfx2b.wav");
    private sfx combo2csfx = new sfx("sounds/combosfx2c.wav");
    private sfx combo3asfx = new sfx("sounds/combosfx3a.wav");
    private sfx combo3bsfx = new sfx("sounds/combosfx3b.wav");
    private sfx combo3csfx = new sfx("sounds/combosfx3c.wav");
    private sfx lvlSFX = new sfx("sounds/lvlSFX.wav");
    private sfx startTheme = new sfx("sounds/startTheme.wav");
    private bgm bgmHandler = new bgm();
    private shipSprite shipfollower;

    public Game() {
        this.bgmHandler.setActiveTrack(5);
        JFrame container = new JFrame("Detrivore Attack");
        JPanel panel = (JPanel)container.getContentPane();
        panel.setPreferredSize(new Dimension(1000, 1000));
        panel.setLayout(null);
        this.setBounds(0, 0, 1000, 1000);
        panel.add(this);
        this.setIgnoreRepaint(true);
        container.pack();
        container.setResizable(false);
        container.setVisible(true);
        container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(new KeyInputHandler());
        this.requestFocus();
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
        this.initEntities();
        this.gameLoop();
    }

    private void initEntities() {
        this.ship = new ShipEntity(this, "sprites/ship.png", 50, 900, 3);
        this.shipfollower = new shipSprite("sprites/ship.png", 5, 5, this.ship);
        this.initLevel("sprites/lvl3.png");
        this.initAliens();
        this.entities.add(this.ship);
        this.entities.add(this.shipfollower);
    }

    public void updateLogic() {
        this.logicRequiredThisLoop = true;
    }

    public void removeEntity(Entity entity) {
        this.removeEntities.add(entity);
    }

    public void notifyDeath() {
        if (this.round > this.getScore()) {
            this.recordScore(this.round);
            this.best = this.round;
        }
        this.round = 1;
        this.alienN = 1;
        this.waitingForKeyPress = true;
        this.leftPressed = false;
        this.rightPressed = false;
        this.firePressed = false;
        this.jumpPressed = false;
        this.downpressed = false;
        this.count = 0;
        this.resetcombo();
    }

    public void tryToFire() {
        if (System.currentTimeMillis() - this.lastFire < this.firingInterval && !this.waitingForKeyPress) {
            return;
        }
        this.lastFire = System.currentTimeMillis();
        int msx = 0;
        int msy = 0;
        if (this.ship.getHorizontalMovement() != 0.0) {
            msx = this.ship.getHorizontalMovement() > 0.0 ? 1500 : -1500;
        }
        if (this.ship.getVerticalMovement() != 0.0) {
            msy = this.ship.getVerticalMovement() > 0.0 ? 1500 : -1500;
        }
        ShotEntity shot = new ShotEntity(this, "sprites/shot1/shot1a.png", this.ship.getX() - 10, this.ship.getY() - 10, 1, msy, msx, 0);
        this.entities.add(shot);
    }

    /*
     * WARNING - void declaration
     */
    public void gameLoop() {
        long lastLoopTime = System.nanoTime();
        while (this.gameRunning) {
            Object entity;
            long delta = System.nanoTime() - lastLoopTime;
            lastLoopTime = System.nanoTime();
            Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
            this.bg.draw(g, 0, 0);
            this.ship.move(delta);
            if (!this.waitingForKeyPress) {
                try {
                    for (Entity e : this.entities) {
                        if (e instanceof ShipEntity) continue;
                        e.move(delta);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int i = 0;
            while (i < this.entities.size()) {
                int j = i + 1;
                while (j < this.entities.size()) {
                    try {
                        Entity me = this.entities.get(i);
                        Entity him = this.entities.get(j);
                        if (!(me instanceof Tile && him instanceof Tile || !me.collidesWith(him))) {
                            me.collidedWith(him);
                            him.collidedWith(me);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("oop");
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.entities.size()) {
                entity = this.entities.get(i);
                if (!(entity instanceof Tile) && !(entity instanceof ShipEntity)) {
                    ((Entity)entity).draw(g);
                }
                ++i;
            }
            if (this.shadowtime > 1) {
                try {
                    Graphics2D g2d = this.shadowspace.createGraphics();
                    g2d.setBackground(this.CLEAR);
                    g2d.clearRect(0, 0, 200, 200);
                    this.cast(this.entities, this.getShipXY(), g2d);
                    g.drawImage(this.shadowspace, this.at, null);
                    g2d.dispose();
                }
                catch (Exception e) {
                    System.out.println("oop2");
                }
                this.shadowtime = 0;
            } else {
                ++this.shadowtime;
                g.drawImage(this.shadowspace, this.at, null);
            }
            i = 0;
            while (i < this.entities.size()) {
                entity = this.entities.get(i);
                if (entity instanceof Tile) {
                    ((Entity)entity).draw(g);
                }
                ++i;
            }
            this.entities.removeAll(this.removeEntities);
            for (Entity block : this.removeEntities) {
                void tile;
                Entity entity2 = block;
                if (!(entity2 instanceof Tile)) continue;
                Tile cfr_ignored_0 = (Tile)entity2;
                Tile cfr_ignored_1 = (Tile)entity2;
                this.tiles.remove(tile);
            }
            this.removeEntities.clear();
            if (this.logicRequiredThisLoop) {
                i = 0;
                while (i < this.entities.size()) {
                    entity = this.entities.get(i);
                    ((Entity)entity).doLogic();
                    ++i;
                }
                this.logicRequiredThisLoop = false;
            }
            if (this.debug) {
                String frametime = "";
                String sround = "round ";
                frametime = String.valueOf(frametime) + 1000000000L / delta;
                frametime = String.valueOf(frametime) + " fps";
                g.setColor(Color.WHITE);
                g.drawString(frametime, 5, 990);
            }
            String sround = "round ";
            sround = String.valueOf(sround) + this.round;
            Graphics2D ts = this.textspace.createGraphics();
            ts.setBackground(this.CLEAR);
            ts.setFont(this.f);
            ts.clearRect(0, 0, 500, 500);
            ts.setColor(this.tShadow);
            ts.fill(new Rectangle(487 - ts.getFontMetrics(this.f).stringWidth(sround), 480, 100, 100));
            ts.setColor(Color.WHITE);
            ts.drawString(sround, 495 - ts.getFontMetrics(this.f).stringWidth(sround), 495);
            if (this.waitingForKeyPress) {
                ts.setColor(this.tShadow);
                ts.fill(new Rectangle(0, 451, 135, 49));
                ts.setColor(Color.WHITE);
                ts.drawString("press space to start!!", 5, 480);
                ts.drawString("(or 1 for the tutorial)", 5, 495);
                ts.drawString("high score = " + this.best, 5, 465);
            }
            g.drawImage(this.textspace, this.bt, null);
            ts.dispose();
            if (this.combo == 0) {
                this.combo0.draw(g, 940, 10);
            } else if (this.combo == 1) {
                this.combo1.draw(g, 940, 10);
            } else if (this.combo == 2) {
                this.combo2.draw(g, 940, 10);
            } else if (this.combo == 3) {
                this.combo3.draw(g, 940, 10);
            } else if (this.combo == 5) {
                this.combo5.draw(g, 940, 10);
            } else if (this.combo == 10) {
                this.combo10.draw(g, 940, 10);
            } else if (this.combo == 20) {
                this.combo20.draw(g, 940, 10);
            } else if (this.combo == 50) {
                this.combo50.draw(g, 940, 10);
            }
            g.setColor(this.tShadow);
            g.fill(new Rectangle(0, 0, 30, 20 * this.ship.getHP() + 10));
            int i2 = 0;
            while (i2 < this.ship.getHP()) {
                this.heart.draw(g, 5, 5 + i2 * 20);
                ++i2;
            }
            if (this.waitingForKeyPress) {
                if (this.tutorial == 0) {
                    this.title.draw(g, 250, 250);
                }
                if (this.tutorial == 1) {
                    this.tutorial1.draw(g, 0, 0);
                }
                if (this.tutorial == 2) {
                    this.tutorial2.draw(g, 0, 0);
                }
            }
            g.dispose();
            this.strategy.show();
            this.ship.setHorizontalMovement(0.0);
            this.ship.setVerticalMovement(0.0);
            if (this.leftPressed && !this.rightPressed) {
                this.ship.setHorizontalMovement(-this.moveSpeed);
            } else if (this.rightPressed && !this.leftPressed) {
                this.ship.setHorizontalMovement(this.moveSpeed);
            }
            if (this.jumpPressed && !this.downpressed) {
                this.ship.setVerticalMovement(-this.moveSpeed);
            } else if (this.downpressed && !this.jumpPressed) {
                this.ship.setVerticalMovement(this.moveSpeed);
            }
            if (!this.firePressed) continue;
            this.tryToFire();
        }
    }

    private void startGame() {
        this.leftPressed = false;
        this.rightPressed = false;
        this.firePressed = false;
        this.tutorial = 3;
        this.temp = false;
        this.bgmHandler.setVolume(0);
        this.startTheme.play();
        try {
            Thread.sleep(2500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bgmHandler.setActiveTrack(0);
        this.bgmHandler.setVolume(5);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entities.clear();
        this.initEntities();
        this.waitingForKeyPress = false;
        this.tutorial = 0;
    }

    public static void main(String[] args) {
        new Game();
    }

    public void initLevel(String r) {
        for (Entity i : this.entities) {
            if (!(i instanceof Tile)) continue;
            this.removeEntity(i);
        }
        Sprite img = SpriteStore.get().getSprite(r);
        System.out.println(img.getHeight());
        System.out.println(img.getWidth());
        int i = 0;
        while (i < img.getHeight()) {
            int j = 0;
            while (j < img.getWidth()) {
                switch (((BufferedImage)img.image).getRGB(i, j)) {
                    case -16777216: {
                        Tile tile = new Tile(i * 10, j * 10, 10, "sprites/block.png");
                        this.entities.add(tile);
                        break;
                    }
                    case -65536: {
                        this.alienSpawners[0] = i * 10;
                        this.alienSpawners[1] = j * 10;
                        break;
                    }
                    case -16711936: {
                        this.alienSpawners[2] = i * 10;
                        this.alienSpawners[3] = j * 10;
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public int[] getShipXY() {
        int[] returnInts = new int[]{this.ship.getX() + 5, this.ship.getY() + 5};
        return returnInts;
    }

    /*
     * WARNING - void declaration
     */
    public void cast(ArrayList<Entity> shadowcasters, int[] lightXY, Graphics2D g) {
        int lx = lightXY[0] / 5 + 1;
        int ly = lightXY[1] / 5 + 1;
        int[] pointx = new int[4];
        int[] pointy = new int[4];
        for (Entity i : shadowcasters) {
            void shadowcaster;
            Entity entity = i;
            if (!(entity instanceof Tile)) continue;
            Tile cfr_ignored_0 = (Tile)entity;
            Tile cfr_ignored_1 = (Tile)entity;
            int x = shadowcaster.getX() / 5;
            int y = shadowcaster.getY() / 5;
            int size = shadowcaster.getSize() / 5;
            if (x + 15 < lx && y + 15 < ly) {
                pointx[0] = x + size;
                pointy[0] = y;
                pointx[1] = x;
                pointy[1] = y + size;
            } else if (x + 15 > lx && y + 15 < ly) {
                pointx[0] = x + size;
                pointy[0] = y + size;
                pointx[1] = x;
                pointy[1] = y;
            } else if (x + 15 > lx && y + 15 > ly) {
                pointx[0] = x;
                pointy[0] = y + size;
                pointx[1] = x + size;
                pointy[1] = y;
            } else if (x + 15 < lx && y + 15 > ly) {
                pointx[0] = x;
                pointy[0] = y;
                pointx[1] = x + size;
                pointy[1] = y + size;
            }
            pointx[2] = (pointx[1] - lx) * 200;
            pointy[2] = (pointy[1] - ly) * 200;
            pointx[3] = (pointx[0] - lx) * 200;
            pointy[3] = (pointy[0] - ly) * 200;
            Polygon shadow = new Polygon(pointx, pointy, 4);
            g.setColor(this.ShadowColor);
            g.fill(shadow);
        }
    }

    public void alienshoot(int x, int y, int a, int b) {
        if (this.lasttime - System.currentTimeMillis() < -150L) {
            ShotEntity Ashot = new ShotEntity(this, "sprites/shot2/shot2a.png", x, y, 1, a * (2 + this.combo / 20), b * (2 + this.combo / 20), 1);
            this.entities.add(Ashot);
            this.lasttime = System.currentTimeMillis();
        }
    }

    public void death(int x, int y, int msx, int msy, String r, boolean h) {
        this.entities.add(new dead(this, x, y, msx, msy, r, h));
    }

    public void initAliens() {
        if (Math.abs(this.alienSpawners[0] - this.ship.getX()) < 100 && Math.abs(this.alienSpawners[1] - this.ship.getY()) < 100) {
            if (this.alienSpawners[0] > this.ship.getX()) {
                if (this.alienSpawners[0] - this.ship.getX() < 100) {
                    this.alienSpawners[0] = this.ship.getX() + 100;
                }
            } else if (this.alienSpawners[0] - this.ship.getX() > -100) {
                this.alienSpawners[0] = this.ship.getX() + 100;
            }
            if (this.alienSpawners[1] > this.ship.getY()) {
                if (this.alienSpawners[1] - this.ship.getY() < 100) {
                    this.alienSpawners[1] = this.ship.getY() + 100;
                }
            } else if (this.alienSpawners[1] - this.ship.getY() > -100) {
                this.alienSpawners[1] = this.ship.getY() + 100;
            }
        }
        if (this.alienSpawners[2] > this.ship.getX()) {
            if (this.alienSpawners[2] - this.ship.getX() < 100) {
                this.alienSpawners[2] = this.ship.getX() + 100;
            }
        } else if (this.alienSpawners[2] - this.ship.getX() > -100) {
            this.alienSpawners[2] = this.ship.getX() + 100;
        }
        if (Math.abs(this.alienSpawners[2] - this.ship.getX()) < 100 && Math.abs(this.alienSpawners[3] - this.ship.getY()) < 100) {
            if (this.alienSpawners[3] > this.ship.getY()) {
                if (this.alienSpawners[3] - this.ship.getY() < 100) {
                    this.alienSpawners[3] = this.ship.getY() + 100;
                }
            } else if (this.alienSpawners[3] - this.ship.getY() > -100) {
                this.alienSpawners[3] = this.ship.getY() + 100;
            }
        }
        int i = 0;
        while (i < this.round) {
            if ((int)(Math.random() * 3.0) == 1) {
                alien2 aliena = new alien2(this, this.alienSpawners[0] + i * 20, this.alienSpawners[1], this.round);
                this.entities.add(aliena);
            } else {
                alien1 alienb = new alien1(this, this.alienSpawners[2], this.alienSpawners[3] + i * 30, this.round);
                this.entities.add(alienb);
            }
            ++i;
        }
    }

    public void alienDead() {
        block26: {
            block25: {
                --this.alienN;
                int tempA = this.combo;
                ++this.combocount;
                this.bgmHandler.setActiveTrack(0);
                if (this.combocount == 1) {
                    this.combo = 1;
                    this.bgmHandler.setActiveTrack(1);
                } else if (this.combocount == 2) {
                    this.combo = 2;
                    this.bgmHandler.setActiveTrack(1);
                } else if (this.combocount <= 4) {
                    this.combo = 3;
                    this.bgmHandler.setActiveTrack(1);
                } else if (this.combocount <= 9) {
                    this.combo = 5;
                    this.bgmHandler.setActiveTrack(2);
                } else if (this.combocount <= 19) {
                    this.combo = 10;
                    this.bgmHandler.setActiveTrack(3);
                } else if (this.combocount <= 49) {
                    this.combo = 20;
                    this.bgmHandler.setActiveTrack(4);
                } else if (this.combocount >= 50) {
                    this.combo = 50;
                    this.bgmHandler.setActiveTrack(5);
                }
                this.moveSpeed = this.combo != 50 ? (double)(500 + 20 * this.combo) : 1000.0;
                if (this.combo <= tempA || tempA == 1 || tempA == 2) break block25;
                switch ((int)(Math.random() * 3.0)) {
                    case 0: {
                        this.combo1asfx.play();
                        break block26;
                    }
                    case 1: {
                        this.combo1bsfx.play();
                        break block26;
                    }
                    case 2: {
                        this.combo1csfx.play();
                        break block26;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            switch ((int)(Math.random() * 3.0)) {
                case 0: {
                    this.combo3asfx.play();
                    break;
                }
                case 1: {
                    this.combo3bsfx.play();
                    break;
                }
                case 2: {
                    this.combo3csfx.play();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.alienN <= 0) {
            this.alienN = 0;
            ++this.round;
            this.alienN += this.round;
            ++this.count;
            this.ship.heal();
            if (this.count == 2) {
                this.initLevel("sprites/lvl" + (int)(Math.random() * 10.0 + 1.0) + ".png");
                this.lvlSFX.play();
                this.count = 0;
            }
            this.initAliens();
        }
    }

    public void resetcombo() {
        switch ((int)(Math.random() * 3.0)) {
            case 0: {
                this.combo2asfx.play();
                break;
            }
            case 1: {
                this.combo2bsfx.play();
                break;
            }
            case 2: {
                this.combo2bsfx.play();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.combocount = 0;
        this.combo = 0;
        this.moveSpeed = 500.0;
        this.bgmHandler.setActiveTrack(0);
    }

    public void decombo() {
        switch ((int)(Math.random() * 3.0)) {
            case 0: {
                this.combo2asfx.play();
                break;
            }
            case 1: {
                this.combo2bsfx.play();
                break;
            }
            case 2: {
                this.combo2bsfx.play();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (this.combo == 1) {
            this.combo = 0;
            this.combocount = 0;
            this.bgmHandler.setActiveTrack(0);
        } else if (this.combo == 2) {
            this.combo = 1;
            this.combocount = 1;
            this.bgmHandler.setActiveTrack(1);
        } else if (this.combo == 3) {
            this.combo = 2;
            this.combocount = 2;
            this.bgmHandler.setActiveTrack(1);
        } else if (this.combo == 5) {
            this.combo = 3;
            this.combocount = 3;
            this.bgmHandler.setActiveTrack(1);
        } else if (this.combo == 10) {
            this.combo = 5;
            this.combocount = 5;
            this.bgmHandler.setActiveTrack(2);
        } else if (this.combo == 20) {
            this.combo = 10;
            this.combocount = 10;
            this.bgmHandler.setActiveTrack(3);
        } else if (this.combo == 50) {
            this.combo = 20;
            this.combocount = 20;
            this.bgmHandler.setActiveTrack(4);
        }
    }

    public int getcombo() {
        return this.combo;
    }

    public void updateshipsprite() {
        this.shipfollower.update();
    }

    public int getScore() {
        try {
            String content;
            if (!Files.exists(SAVE_FILE, new LinkOption[0])) {
                Files.createDirectories(SAVE_FILE.getParent(), new FileAttribute[0]);
                Files.writeString(SAVE_FILE, (CharSequence)"0", new OpenOption[0]);
            }
            return Integer.parseInt((content = Files.readString(SAVE_FILE).trim()).isEmpty() ? "0" : content);
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void recordScore(int score) {
        try {
            if (!Files.exists(SAVE_FILE.getParent(), new LinkOption[0])) {
                Files.createDirectories(SAVE_FILE.getParent(), new FileAttribute[0]);
            }
            Files.writeString(SAVE_FILE, (CharSequence)String.valueOf(score), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private int pressCount = 1;

        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (Game.this.waitingForKeyPress) {
                return;
            }
            if (e.getKeyCode() == 80) {
                Game.this.notifyDeath();
            }
            if (e.getKeyCode() == 65) {
                Game.this.leftPressed = true;
            }
            if (e.getKeyCode() == 68) {
                Game.this.rightPressed = true;
            }
            if (e.getKeyCode() == 32) {
                Game.this.firePressed = true;
            }
            if (e.getKeyCode() == 87) {
                Game.this.jumpPressed = true;
            }
            if (e.getKeyCode() == 83) {
                Game.this.downpressed = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 49) {
                Game.this.temp = false;
            }
            if (Game.this.waitingForKeyPress) {
                return;
            }
            if (e.getKeyCode() == 65) {
                Game.this.leftPressed = false;
            }
            if (e.getKeyCode() == 68) {
                Game.this.rightPressed = false;
            }
            if (e.getKeyCode() == 32) {
                Game.this.firePressed = false;
            }
            if (e.getKeyCode() == 87) {
                Game.this.jumpPressed = false;
            }
            if (e.getKeyCode() == 83) {
                Game.this.downpressed = false;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (Game.this.waitingForKeyPress) {
                if (this.pressCount == 1) {
                    if (e.getKeyChar() == ' ') {
                        Game.this.startGame();
                        Game.this.bgmHandler.setActiveTrack(0);
                        this.pressCount = 0;
                    }
                    if (e.getKeyChar() == '0') {
                        Game.this.debug = true;
                        this.pressCount = 0;
                    }
                    if (e.getKeyChar() == '1') {
                        if (Game.this.tutorial == 0 && !Game.this.temp) {
                            Game.this.tutorial = 1;
                            System.out.print('a');
                            Game.this.temp = true;
                            this.pressCount = 0;
                        }
                        if (Game.this.tutorial == 1 && !Game.this.temp) {
                            Game.this.tutorial = 2;
                            System.out.print('b');
                            Game.this.temp = true;
                            this.pressCount = 0;
                        }
                    }
                } else {
                    ++this.pressCount;
                }
            }
            if (e.getKeyChar() == '\u001b') {
                System.exit(0);
            }
        }
    }
}

