/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;

public class TrafficCars
extends Entity {
    private double moveSpeed;
    private Game game;

    public TrafficCars(Game g, String r, int newX, int newY, int moveSpeed) {
        super(r, newX, newY);
        this.game = g;
        this.dy += (double)moveSpeed;
        this.hitboxOffsetX = 13;
        this.hitboxOffsetY = 5;
        this.hitboxWidth = this.sprite.getWidth() - 2 * this.hitboxOffsetX;
        this.hitboxHeight = this.sprite.getHeight() - 2 * this.hitboxOffsetY;
        this.moveSpeed = moveSpeed;
        this.dy = moveSpeed;
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (this.y > 950.0) {
            this.game.removeEntity(this);
        }
    }

    public TrafficCars getCarInFront() {
        TrafficCars closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity e : this.game.getEntities()) {
            double distance;
            TrafficCars other;
            if (!(e instanceof TrafficCars) || (other = (TrafficCars)e) == this || Math.abs(other.x - this.x) > 5.0 || other.y >= this.y || !((distance = this.y - other.y) < closestDistance)) continue;
            closestDistance = distance;
            closest = other;
        }
        return closest;
    }

    @Override
    public void updateMovement() {
        double distance;
        TrafficCars front = this.getCarInFront();
        double bg = this.game.background.getScrollSpeed();
        if (front != null && (distance = (double)(front.getY() - this.getY())) < 20.0) {
            double crawlSpeed = 2.0;
            this.dy = Math.max(crawlSpeed, bg - this.moveSpeed);
            return;
        }
        this.dy = bg - this.moveSpeed;
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof TrafficCars) {
            this.game.removeEntity(other);
        }
    }

    @Override
    public boolean collidesWith(Entity other) {
        Rectangle me = new Rectangle((int)this.x + this.hitboxOffsetX, (int)this.y + this.hitboxOffsetY, this.hitboxWidth, this.hitboxHeight);
        Rectangle him = new Rectangle(other.getX() + other.hitboxOffsetX, other.getY() + other.hitboxOffsetY, other.hitboxWidth, other.hitboxHeight);
        return me.intersects(him);
    }
}

