/*
 * Decompiled with CFR 0.152.
 */
public class Timer {
    private long startTime = 0L;
    private long accumulatedTime = 0L;
    private boolean isRunning = false;

    public void start() {
        if (!this.isRunning) {
            this.startTime = System.currentTimeMillis();
            this.isRunning = true;
        }
    }

    public void pause() {
        if (this.isRunning) {
            this.accumulatedTime += System.currentTimeMillis() - this.startTime;
            this.isRunning = false;
        }
    }

    public void stop() {
        this.isRunning = false;
        this.accumulatedTime = 0L;
        this.startTime = 0L;
    }

    public long getTime() {
        if (this.isRunning) {
            return this.accumulatedTime + (System.currentTimeMillis() - this.startTime);
        }
        return this.accumulatedTime;
    }

    public String toString() {
        long totalSeconds = this.getTime() / 1000L;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d", minutes, seconds);
    }
}

