/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Game
extends Canvas {
    private boolean waitingForKeyPress = true;
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    private boolean upPressed = false;
    private boolean downPressed = false;
    private boolean pausePressed = false;
    public BackgroundEntity background;
    private boolean gameRunning = true;
    private ArrayList<Entity> entities = new ArrayList();
    private ArrayList<Cars> carsList = new ArrayList();
    private long lastSpawn = 0L;
    private long lastSpawnCoin = 0L;
    private boolean upgradeAvailable = false;
    private long upgradeFlashTimer = 0L;
    private boolean upgradeFlashVisible = true;
    private ArrayList<Entity> removeEntities = new ArrayList();
    private CarEntity car;
    private double moveSpeed = 600.0;
    private String message = "";
    private int currentCarLevel = 0;
    private boolean logicRequiredThisLoop = false;
    private BufferStrategy strategy;
    private int screen = 0;
    private boolean blinking = true;
    private long lastBlinkTime = 0L;
    private long blinkInterval = 500L;
    private Font startingFont = new Font("Monospaced", 1, 48);
    private BufferedImage[] introImages = new BufferedImage[3];
    private BufferedImage endImage;
    private BufferedImage speedIcon;
    private Coin coin;
    private int coins = 0;
    private double distance = 0.0;
    private Image pauseImage;
    private Image playImage;
    private boolean showingUnpause = false;
    private long unpauseStartTime = 0L;
    private boolean gameOver = false;
    private Timer timer = new Timer();
    private long gameOverElapsed = 0L;
    private final long restartDelay = 1000L;
    private int displayedSpeed;
    private double highScore = Math.pow(this.distance, 2.0) / (double)this.timer.getTime();
    private Font crang;
    private final String[] carNames = new String[]{"Toyota Supra", "Lotus Elise", "Porsche 911 Carrera", "Chevrolet Corvette", "Dodge Viper GTS", "Audi R8 GT", "Mercedes SLS AMG", "Ferrari 458 Italia", "Lamborghini Murci\u00e9lago", "Aston Martin DB9", "Pagani Zonda F", "Bugatti Veyron", "Koenigsegg CCX", "McLaren F1"};

    public Game() {
        JFrame container = new JFrame("Daytona Dash");
        JPanel panel = (JPanel)container.getContentPane();
        panel.setPreferredSize(new Dimension(1200, 900));
        panel.setLayout(null);
        this.setBounds(0, 0, 1200, 900);
        panel.add(this);
        this.setIgnoreRepaint(true);
        container.pack();
        container.setResizable(false);
        container.setVisible(true);
        container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(new KeyInputHandler());
        this.requestFocus();
        this.createBufferStrategy(2);
        try {
            this.pauseImage = ImageIO.read(this.getClass().getResource("/sprites/pause.png"));
            this.playImage = ImageIO.read(this.getClass().getResource("/sprites/play.png"));
            this.introImages[0] = ImageIO.read(this.getClass().getResource("/sprites/intro.png"));
            this.introImages[1] = ImageIO.read(this.getClass().getResource("/sprites/intro1.png"));
            this.introImages[2] = ImageIO.read(this.getClass().getResource("/sprites/intro2.png"));
            this.endImage = ImageIO.read(this.getClass().getResource("/sprites/gameover.png"));
            this.speedIcon = ImageIO.read(this.getClass().getResourceAsStream("/sprites/speedIcon.png"));
            Font crangBase = Font.createFont(0, this.getClass().getResourceAsStream("/font/Crang.ttf"));
            this.crang = crangBase.deriveFont(30.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.strategy = this.getBufferStrategy();
        this.initCars();
        this.initEntities();
        this.gameLoop();
    }

    public void addTrafficCar() {
        long spawnCoolDown = 3000L;
        if (System.currentTimeMillis() - this.lastSpawn < spawnCoolDown || this.displayedSpeed < 20) {
            return;
        }
        this.lastSpawn = System.currentTimeMillis();
        int[] laneCenters = new int[]{270, 450, 640, 825};
        boolean[] usedLane = new boolean[laneCenters.length];
        int i = 0;
        while (i < 3) {
            int laneIndex = (int)(Math.random() * (double)laneCenters.length);
            if (laneIndex != 0 && !usedLane[laneIndex]) {
                usedLane[laneIndex] = true;
                int x = laneCenters[laneIndex];
                int randomHeight = -200 - (int)(Math.random() * 200.0);
                int randomSpeed = 100 + (int)(Math.random() * 401.0);
                TrafficCars car = new TrafficCars(this, "sprites/car4.png", x, randomHeight, randomSpeed);
                this.entities.add(car);
            }
            ++i;
        }
    }

    public void addCoin() {
        long spawnCoolDown = 3000L;
        int[] positions = new int[]{270, 450, 640, 825};
        if (System.currentTimeMillis() - this.lastSpawnCoin < spawnCoolDown || this.displayedSpeed < 30) {
            return;
        }
        this.lastSpawnCoin = System.currentTimeMillis();
        int laneIndex = (int)(Math.random() * (double)positions.length);
        int x = positions[laneIndex];
        this.coin = new Coin(this, "sprites/Coin.gif", x, -100);
        this.entities.add(this.coin);
    }

    public void coinUp() {
        ++this.coins;
        int newLevel = this.coins / 1;
        if (newLevel > this.currentCarLevel && newLevel < this.carsList.size()) {
            this.upgradeAvailable = true;
            this.upgradeFlashTimer = System.currentTimeMillis();
        }
    }

    public void initCars() {
        this.carsList.clear();
        int i = 0;
        while (i < 14) {
            double maxSpeed = 600.0;
            double acceleration = 100.0;
            double turnSpeed = 500.0;
            double friction = 50.0;
            double braking = 1000.0;
            int durability = 100;
            double multiplier = 1.0 + (double)i * 0.5;
            if (i == 4) {
                multiplier += 0.1;
            } else if (i == 9) {
                multiplier += 0.15;
            }
            durability = (int)((double)durability + (double)i * 0.3);
            String sprite = "sprites/car" + i + ".png";
            this.carsList.add(new Cars(maxSpeed *= multiplier, acceleration *= multiplier, turnSpeed *= 0.9 + multiplier * 0.1, friction *= 1.0 + (double)i * 0.02, braking *= 1.0 + (double)i * 0.04, durability, sprite));
            ++i;
        }
    }

    private void initEntities() {
        this.background = new BackgroundEntity("sprites/road.png", 900);
        this.entities.add(this.background);
        this.car = new CarEntity(this, "sprites/car" + this.currentCarLevel + ".png", 370, 550);
        this.updateCar(this.currentCarLevel);
        this.entities.add(this.car);
    }

    public void updateCar(int currentCarLevel) {
        Cars nextCar = this.carsList.get(currentCarLevel);
        this.car.updateCar(nextCar.getMaxSpeed(), nextCar.getAcceleration(), nextCar.getTurnSpeed(), nextCar.getFriction(), nextCar.getBraking(), nextCar.getDurability(), nextCar.getSprite());
    }

    public void updateLogic() {
        this.logicRequiredThisLoop = true;
    }

    public void removeEntity(Entity entity) {
        this.removeEntities.add(entity);
    }

    public void notifyDeath() {
        this.timer.pause();
        this.waitingForKeyPress = true;
        this.gameOver = true;
        this.screen = 4;
        this.gameOverElapsed = 0L;
        this.highScore = Math.pow(this.distance, 2.0) / (double)this.timer.getTime();
    }

    public void gameLoop() {
        long lastLoopTime = System.currentTimeMillis();
        while (this.gameRunning) {
            long delta = System.currentTimeMillis() - lastLoopTime;
            lastLoopTime = System.currentTimeMillis();
            switch (this.screen) {
                case 0: {
                    this.showIntro1();
                    break;
                }
                case 1: {
                    this.showIntro2();
                    break;
                }
                case 2: {
                    this.showIntro3();
                    break;
                }
                case 3: {
                    this.updateGame(delta);
                    break;
                }
                case 4: {
                    this.updateEndScreen();
                    this.gameOverElapsed += delta;
                }
            }
        }
    }

    private void updateEndScreen() {
        Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
        g.setColor(Color.yellow);
        g.fillRect(0, 0, 1200, 900);
        if (this.endImage != null) {
            g.drawImage((Image)this.endImage, 0, 0, null);
            g.setFont(this.crang);
            int rightX = 930;
            String scoreText = String.format("%2.2f", this.highScore);
            int scoreWidth = g.getFontMetrics().stringWidth(scoreText);
            g.drawString(scoreText, rightX - scoreWidth, 470);
            String timeText = this.timer.toString();
            int timeWidth = g.getFontMetrics().stringWidth(timeText);
            g.drawString(timeText, rightX - timeWidth, 520);
            String distanceText = String.format("%d km", (int)this.distance);
            int distWidth = g.getFontMetrics().stringWidth(distanceText);
            g.drawString(distanceText, rightX - distWidth, 570);
            String coinText = String.valueOf(this.coins);
            int coinWidth = g.getFontMetrics().stringWidth(coinText);
            g.drawString(coinText, rightX - coinWidth, 620);
        }
        g.dispose();
        this.strategy.show();
    }

    private void showIntro1() {
        Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.introImages[0] != null) {
            g.drawImage((Image)this.introImages[0], 0, 0, null);
        }
        if (System.currentTimeMillis() - this.lastBlinkTime > this.blinkInterval) {
            this.blinking = !this.blinking;
            this.lastBlinkTime = System.currentTimeMillis();
        }
        if (this.blinking) {
            String text = "PRESS ANY KEY TO CONTINUE!";
            g.setFont(new Font("Monospaced", 1, 40));
            int x = (1200 - g.getFontMetrics().stringWidth(text)) / 2;
            int y = 450;
            g.setColor(Color.BLACK);
            int outlineThickness = 3;
            int dx = -outlineThickness;
            while (dx <= outlineThickness) {
                int dy = -outlineThickness;
                while (dy <= outlineThickness) {
                    if (dx != 0 || dy != 0) {
                        g.drawString(text, x + dx, y + dy);
                    }
                    ++dy;
                }
                ++dx;
            }
            g.setColor(Color.YELLOW);
            g.drawString(text, x, y);
        }
        g.dispose();
        this.strategy.show();
    }

    private void showIntro2() {
        Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.introImages[1] != null) {
            g.drawImage((Image)this.introImages[1], 0, 0, null);
        }
        g.dispose();
        this.strategy.show();
    }

    private void showIntro3() {
        Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.introImages[2] != null) {
            g.drawImage((Image)this.introImages[2], 0, 0, null);
        }
        g.dispose();
        this.strategy.show();
    }

    private void drawCarName(Graphics2D g) {
        if (this.currentCarLevel >= 0 && this.currentCarLevel < this.carNames.length) {
            String carName = this.carNames[this.currentCarLevel];
            g.setFont(new Font("Arial", 1, 24));
            int textWidth = g.getFontMetrics().stringWidth(carName);
            int x = 1180 - textWidth;
            int y = 50;
            g.setColor(Color.BLACK);
            g.drawString(carName, x + 2, y + 2);
            g.setColor(Color.WHITE);
            g.drawString(carName, x, y);
        }
    }

    private void drawCoinsCollected(Graphics2D g) {
        g.setFont(new Font("Arial", 1, 24));
        String coinText = "Coins: " + this.coins;
        int x = 1050;
        int y = 80;
        g.setColor(Color.BLACK);
        g.drawString(coinText, x + 2, y + 2);
        g.setColor(Color.WHITE);
        g.drawString(coinText, x, y);
    }

    private void updateGame(long delta) {
        Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
        this.distance += this.background.getScrollSpeed() * (double)delta / 216000.0;
        if (!this.pausePressed && !this.waitingForKeyPress) {
            this.addCoin();
            this.addTrafficCar();
            this.car.updateMovement(this.leftPressed, this.rightPressed, this.upPressed, this.downPressed, delta);
            for (Entity entity : this.entities) {
                entity.move(delta);
                if (!(entity instanceof TrafficCars) && !(entity instanceof Coin)) continue;
                entity.updateMovement();
            }
            int i = 0;
            while (i < this.entities.size()) {
                int j = i + 1;
                while (j < this.entities.size()) {
                    Entity him;
                    Entity me = this.entities.get(i);
                    if (me.collidesWith(him = this.entities.get(j))) {
                        me.collidedWith(him);
                        him.collidedWith(me);
                    }
                    ++j;
                }
                ++i;
            }
            if (this.logicRequiredThisLoop) {
                i = 0;
                while (i < this.entities.size()) {
                    Entity entity = this.entities.get(i);
                    entity.doLogic();
                    ++i;
                }
                this.logicRequiredThisLoop = false;
            }
        }
        for (Entity entity : this.entities) {
            entity.draw(g);
        }
        this.drawCarName(g);
        this.drawCoinsCollected(g);
        if (this.pausePressed) {
            g.drawImage(this.pauseImage, this.getWidth() / 2 - this.pauseImage.getWidth(null) / 2, this.getHeight() / 2 - this.pauseImage.getHeight(null) / 2, null);
        }
        if (this.showingUnpause) {
            double timeElapsed = System.currentTimeMillis() - this.unpauseStartTime;
            if (timeElapsed < 200.0) {
                g.drawImage(this.playImage, this.getWidth() / 2 - this.playImage.getWidth(null) / 2, this.getHeight() / 2 - this.playImage.getHeight(null) / 2, null);
            } else {
                this.showingUnpause = false;
            }
        }
        this.entities.removeAll(this.removeEntities);
        int x = this.getWidth() - this.speedIcon.getWidth() - 30;
        int y = this.getHeight() - this.speedIcon.getHeight() - 30;
        g.drawImage((Image)this.speedIcon, x, y, null);
        double rawSpeed = this.background.getScrollSpeed();
        this.displayedSpeed = (int)(rawSpeed / 14.0);
        String speedText = String.format("%02d km/h", this.displayedSpeed);
        g.setFont(new Font("Arial", 1, 30));
        int textX = x + this.speedIcon.getWidth() / 2 - 55;
        int textY = y + this.speedIcon.getHeight() / 2 - 55;
        g.setColor(Color.BLACK);
        g.drawString(speedText, textX + 2, textY + 2);
        g.setColor(Color.WHITE);
        g.drawString(speedText, textX, textY);
        if (this.upgradeAvailable) {
            if (System.currentTimeMillis() - this.upgradeFlashTimer > 500L) {
                this.upgradeFlashVisible = !this.upgradeFlashVisible;
                this.upgradeFlashTimer = System.currentTimeMillis();
            }
            if (this.upgradeFlashVisible) {
                g.setColor(Color.YELLOW);
                g.setFont(new Font("Arial", 1, 20));
                String msg = "UPGRADE AVAILABLE! Press 'space' to upgrade";
                int cx = (1200 - g.getFontMetrics().stringWidth(msg)) / 2;
                g.drawString(msg, cx, 150);
            }
        }
        g.dispose();
        this.strategy.show();
    }

    private void startGame() {
        this.entities.clear();
        this.removeEntities.clear();
        this.leftPressed = false;
        this.rightPressed = false;
        this.upPressed = false;
        this.downPressed = false;
        this.pausePressed = false;
        this.coins = 0;
        this.lastSpawn = 0L;
        this.lastSpawnCoin = 0L;
        this.upgradeAvailable = false;
        this.upgradeFlashVisible = true;
        this.initEntities();
        this.currentCarLevel = 0;
        this.updateCar(this.currentCarLevel);
        this.gameOver = false;
        this.timer.stop();
        this.timer.start();
        this.waitingForKeyPress = false;
    }

    public static void main(String[] args) {
        new Game();
    }

    public ArrayList<Entity> getEntities() {
        return this.entities;
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (Game.this.gameOver && Game.this.screen == 4) {
                if (Game.this.gameOverElapsed >= 1000L) {
                    Game.this.startGame();
                    Game.this.gameOver = false;
                    Game.this.screen = 3;
                }
                return;
            }
            if (Game.this.screen >= 0 && Game.this.screen <= 2) {
                ++Game.this.screen;
                if (Game.this.screen == 3) {
                    Game.this.startGame();
                }
                return;
            }
            if (Game.this.screen == 3) {
                if (e.getKeyCode() == 37) {
                    Game.this.leftPressed = true;
                }
                if (e.getKeyCode() == 39) {
                    Game.this.rightPressed = true;
                }
                if (e.getKeyCode() == 38) {
                    Game.this.upPressed = true;
                }
                if (e.getKeyCode() == 40) {
                    Game.this.downPressed = true;
                }
                if (e.getKeyCode() == 80) {
                    if (!Game.this.pausePressed) {
                        Game.this.pausePressed = true;
                    } else {
                        Game.this.pausePressed = false;
                        Game.this.showingUnpause = true;
                        Game.this.unpauseStartTime = System.currentTimeMillis();
                    }
                }
                if (e.getKeyCode() == 32 && Game.this.upgradeAvailable) {
                    ++Game.this.currentCarLevel;
                    Game.this.updateCar(Game.this.currentCarLevel);
                    Game.this.upgradeAvailable = false;
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (Game.this.screen < 3) {
                return;
            }
            if (e.getKeyCode() == 37) {
                Game.this.leftPressed = false;
            }
            if (e.getKeyCode() == 39) {
                Game.this.rightPressed = false;
            }
            if (e.getKeyCode() == 38) {
                Game.this.upPressed = false;
            }
            if (e.getKeyCode() == 40) {
                Game.this.downPressed = false;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                System.exit(0);
            }
        }
    }
}

