/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;

public class CarEntity
extends Entity {
    private Game game;
    private double velX = 0.0;
    private double velY = 0.0;
    private double maxSpeed;
    private double acceleration;
    private double turnSpeed;
    private double friction = 50.0;
    private double braking;
    private int hitboxOffsetX = 5;
    private int hitboxOffsetY = 5;
    private int hitboxWidth;
    private int hitboxHeight;
    private int durability;
    private int currentDurability;
    private int health;
    private int healthBarWidth = 60;
    private int healthBarHeight = 8;
    private int healthBarOffsetY = -15;

    public CarEntity(Game g, String r, int newX, int newY) {
        super(r, newX, newY);
        this.game = g;
        this.hitboxWidth = this.sprite.getWidth() - this.hitboxOffsetX * 2;
        this.hitboxHeight = this.sprite.getHeight() - this.hitboxOffsetY * 2;
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (this.x < 190.0) {
            this.x = 190.0;
            this.currentDurability -= 20;
        }
        if (this.x > 900.0) {
            this.x = 900.0;
            this.currentDurability -= 20;
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof TrafficCars) {
            this.health = 0;
            this.game.notifyDeath();
        }
        if (other instanceof Coin) {
            this.game.removeEntity(other);
            this.game.coinUp();
        }
    }

    public void updateCar(double maxSpeed, double acceleration, double turnSpeed, double friction, double braking, int durability, String sprite) {
        this.maxSpeed = maxSpeed;
        this.acceleration = acceleration;
        this.turnSpeed = turnSpeed;
        this.friction = friction;
        this.braking = braking;
        this.durability = durability;
        this.sprite = SpriteStore.get().getSprite(sprite);
        this.currentDurability = durability;
        this.health = this.currentDurability / durability;
    }

    @Override
    public boolean collidesWith(Entity other) {
        Rectangle me = new Rectangle((int)this.x + this.hitboxOffsetX, (int)this.y + this.hitboxOffsetY, this.hitboxWidth, this.hitboxHeight);
        Rectangle him = new Rectangle(other.getX(), other.getY(), other.sprite.getWidth(), other.sprite.getHeight());
        return me.intersects(him);
    }

    public void updateMovement(boolean leftPressed, boolean rightPressed, boolean upPressed, boolean downPressed, long delta) {
        this.velX = leftPressed ? -this.turnSpeed : (rightPressed ? this.turnSpeed : 0.0);
        this.velY = upPressed ? (this.velY += this.acceleration * (double)delta / 1000.0) : (downPressed ? (this.velY -= this.braking * (double)delta / 1000.0) : (this.velY -= this.friction * (double)delta / 1000.0));
        if (this.velY < 0.0) {
            this.velY = 0.0;
        }
        if (this.velY > this.maxSpeed) {
            this.velY = this.maxSpeed;
        }
        this.game.background.setScrollSpeed(this.velY);
        this.setHorizontalMovement(this.velX);
    }

    public int getHealth() {
        return this.health;
    }
}

