/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class BackgroundEntity
extends Entity {
    private double scrollSpeed = 200.0;
    private BufferedImage backgroundImage;
    private double y1 = 0.0;
    private double y2;
    private int windowHeight;

    public BackgroundEntity(String r, int windowHeight) {
        super(r, 0, 0);
        this.windowHeight = windowHeight;
        try {
            this.backgroundImage = ImageIO.read(this.getClass().getResourceAsStream("/" + r));
            this.y2 = -this.backgroundImage.getHeight();
        }
        catch (IOException e) {
            System.out.println("Error loading the image: " + e.getMessage());
        }
    }

    @Override
    public void move(long delta) {
        double move = this.scrollSpeed * (double)delta / 1000.0;
        this.y1 += move;
        this.y2 += move;
        if (this.y1 >= (double)this.windowHeight) {
            this.y1 = this.y2 - (double)this.backgroundImage.getHeight();
        }
        if (this.y2 >= (double)this.windowHeight) {
            this.y2 = this.y1 - (double)this.backgroundImage.getHeight();
        }
    }

    @Override
    public void collidedWith(Entity other) {
    }

    @Override
    public boolean collidesWith(Entity other) {
        return false;
    }

    @Override
    public void draw(Graphics g) {
        g.drawImage(this.backgroundImage, (int)this.x, (int)this.y1, null);
        g.drawImage(this.backgroundImage, (int)this.x, (int)this.y2, null);
    }

    public void setScrollSpeed(double speed) {
        this.scrollSpeed = speed;
    }

    public double getScrollSpeed() {
        return this.scrollSpeed;
    }
}

