/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class SlashEntity
extends Entity {
    private Game g;
    private int dmg;
    private long creationTime;
    private final long DURATION_MS = 300L;
    private boolean drawOnce = false;

    public SlashEntity(String r, int newX, int newY, Entity weapon, int dmg, Game g) {
        super(r, newX, newY, 9);
        this.dmg = dmg;
        this.g = g;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof PlayerEntity) {
            return;
        }
        if (other instanceof MobEntity) {
            other.setHP(other.getHP() - this.dmg);
            System.out.println("Mob HP: " + other.getHP());
        }
    }

    @Override
    public void draw(Graphics g, String dir) {
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(this.getX(), this.getY() - 50, this.sprite.getWidth() + 40, this.sprite.getHeight() + 50);
        this.sprite.draw(g, (int)this.x, (int)this.y, dir);
    }

    @Override
    public boolean collidesWith(Entity other) {
        this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
        this.him.setBounds(other.getX(), other.getY(), other.sprite.getWidth(), other.sprite.getHeight());
        return this.me.intersects(this.him);
    }

    @Override
    public void move(long delta) {
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.creationTime;
        if (elapsedTime >= 300L) {
            System.out.println("a");
            this.g.removeEntity(this);
        }
    }
}

