/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

public class SceneManager {
    private GameStates current;
    private Sprite menuImg;
    private Sprite pauseImg;
    private Sprite controlsImg;
    private Sprite endingImg;
    private Sprite storyImg;
    private Sprite deadImg;
    private boolean drawn = false;
    private Game game;

    public SceneManager(Game game, GameStates s) {
        this.game = game;
        this.menuImg = SpriteStore.get().getSprite("scenes/MenuScene.png");
        this.pauseImg = SpriteStore.get().getSprite("scenes/Pause.png");
        this.controlsImg = SpriteStore.get().getSprite("scenes/ControlScene.png");
        this.endingImg = SpriteStore.get().getSprite("scenes/EndScene.png");
        this.storyImg = SpriteStore.get().getSprite("scenes/StoryScene.png");
        this.deadImg = SpriteStore.get().getSprite("scenes/DeathScene.png");
        this.set(s);
    }

    public void set(GameStates g) {
        this.current = g;
    }

    public GameStates get() {
        return this.current;
    }

    public void draw(Graphics g) {
        switch (this.current) {
            case Menu: {
                this.menuImg.draw(g, 0, 0);
                break;
            }
            case Paused: {
                this.pauseImg.draw(g, 0, 0);
                break;
            }
            case Controls: {
                this.controlsImg.draw(g, 0, 0);
                break;
            }
            case Ending: {
                this.endingImg.draw(g, 0, 0);
                break;
            }
            case Story: {
                this.storyImg.draw(g, 0, 0);
                break;
            }
            case Dead: {
                this.deadImg.draw(g, 0, 0);
                break;
            }
        }
    }
}

