/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;

public class PlayerEntity
extends Entity {
    private Game game;
    private boolean jumping = false;
    private int HP = 4;
    private boolean invincible = false;
    private boolean onGround = false;
    private long invincibleTime = 500L;
    private long lastHitTime = 0L;
    private long lastDashTime = 0L;
    private long lastJumpTime = 0L;
    private Rectangle player;
    private double knockbackVX = 0.0;
    private double knockbackVY = 0.0;
    private long knockbackEndTime = 0L;

    public PlayerEntity(Game g, String r, int newX, int newY) {
        super(r, newX, newY, 4);
        this.game = g;
        this.player = super.getAbsoulteBounds();
    }

    public boolean isInvincible() {
        return this.invincible;
    }

    public void setInvincible(boolean b) {
        this.invincible = b;
    }

    public void setLastHitTime(long t) {
        this.lastHitTime = t;
    }

    public void setLastDashTime(long t) {
        this.lastDashTime = t;
    }

    public long getLastHitTime() {
        return this.lastHitTime;
    }

    public long getLastDashTime() {
        return this.lastDashTime;
    }

    public void applyKnockback(double vx, double vy, long duration) {
        this.knockbackVX = vx;
        this.knockbackVY = vy;
        this.knockbackEndTime = System.currentTimeMillis() + duration;
    }

    @Override
    public void move(long delta) {
        long now = System.currentTimeMillis();
        if (now < this.knockbackEndTime) {
            this.x += this.knockbackVX * ((double)delta / 1000.0);
            this.y += this.knockbackVY * ((double)delta / 1000.0);
            return;
        }
        if (!this.onGround) {
            this.dy += Math.pow(GameConstants.getFallMulti(), 2.0);
            this.game.setDirectionVert("up");
            this.onGround = false;
        } else {
            this.game.setDirectionVert("down");
            this.dy = 0.0;
            this.onGround = true;
        }
        this.collision();
        super.setVerticalMovement(this.dy);
        super.move(delta);
    }

    private void collision() {
        Tiles br;
        Tiles bl;
        ArrayList<Tiles> tempAl = new ArrayList<Tiles>();
        try {
            Tiles tl = this.game.getTileM().getTileType(this.game.getMap()[this.getBoundingTop()][this.getBoundingLeft()]);
            tl.indexToCoords(this.getBoundingLeft(), this.getBoundingTop());
            tempAl.add(tl);
            Tiles tr = this.game.getTileM().getTileType(this.game.getMap()[this.getBoundingTop()][this.getBoundingRight()]);
            tr.indexToCoords(this.getBoundingRight(), this.getBoundingTop());
            tempAl.add(tr);
            bl = this.game.getTileM().getTileType(this.game.getMap()[this.getBoundingBottom()][this.getBoundingLeft()]);
            bl.indexToCoords(this.getBoundingLeft(), this.getBoundingBottom());
            tempAl.add(bl);
            br = this.game.getTileM().getTileType(this.game.getMap()[this.getBoundingBottom()][this.getBoundingRight()]);
            br.indexToCoords(this.getBoundingRight(), this.getBoundingBottom());
            tempAl.add(br);
            int midLeftX = this.getBoundingLeft();
            int midLeftY = (this.getBoundingTop() + this.getBoundingBottom()) / 2;
            Tiles ml = this.game.getTileM().getTileType(this.game.getMap()[midLeftY][midLeftX]);
            ml.indexToCoords(midLeftX, midLeftY);
            tempAl.add(ml);
            int midRightX = this.getBoundingRight();
            int midRightY = (this.getBoundingTop() + this.getBoundingBottom()) / 2;
            Tiles mr = this.game.getTileM().getTileType(this.game.getMap()[midRightY][midRightX]);
            mr.indexToCoords(midRightX, midRightY);
            tempAl.add(mr);
        }
        catch (Exception e) {
            return;
        }
        if (bl.getID() != 4 && this.onGround || br.getID() != 4 && this.onGround) {
            this.onGround = false;
        }
        for (Tiles t : tempAl) {
            Rectangle tileBox = t.getBounds();
            switch (t.getID()) {
                case 4: {
                    if (!this.player.intersects(tileBox)) break;
                    Rectangle overlap = this.player.intersection(tileBox);
                    if (overlap.width < overlap.height) {
                        if (this.player.x < tileBox.x) {
                            super.setX((int)(this.player.getX() - (double)overlap.width - 2.0));
                        } else {
                            super.setX((int)(this.player.getX() + (double)overlap.width + 2.0));
                        }
                        this.dx = 0.0;
                    } else if (this.dy > 0.0 && this.player.y < tileBox.y) {
                        super.setY(tileBox.y - this.sprite.getHeight() + 6);
                        this.dy = 0.0;
                        this.onGround = true;
                    } else if (this.dy < 0.0 && this.player.y > tileBox.y) {
                        super.setY(tileBox.y + tileBox.height);
                        this.dy = 0.0;
                    }
                    this.player.setLocation((int)this.player.getX(), (int)this.player.getY());
                    break;
                }
                case 1: {
                    if (this.game.getTileM().getStage() < 4) {
                        this.game.getTileM().changeStage(this.game.getTileM().getStage() + 1);
                        this.game.getEntities().clear();
                        this.game.initEntities();
                        this.onGround = true;
                        break;
                    }
                    this.game.setStates(GameStates.Ending);
                    this.game.getTileM().setStage(1);
                    break;
                }
                case 2: {
                    this.game.notifyDeath();
                }
            }
        }
        tempAl.clear();
    }

    public void draw(Graphics g, String dirVert, String dirHori, char shape) {
        switch (dirVert) {
            case "up": {
                this.sprite = SpriteStore.get().getSprite("sprites/Entity/hero1walk6.png");
                break;
            }
            default: {
                this.sprite = SpriteStore.get().getSprite("sprites/Entity/hero1stand.png");
            }
        }
        this.sprite.draw(g, (int)this.x, (int)this.y, dirHori);
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof MobEntity) {
            this.game.notifyDeath();
        }
    }

    public void tryToDash() {
        if (System.currentTimeMillis() - this.lastDashTime < GameConstants.getDashInterval()) {
            return;
        }
        this.lastDashTime = System.currentTimeMillis();
        if (this.game.getDirectionHori().equals("left")) {
            this.setHorizontalMovement(-GameConstants.getMovespeed() * (this.isOnGround() ? 10 : 20));
        } else {
            this.setHorizontalMovement(GameConstants.getMovespeed() * (this.isOnGround() ? 10 : 20));
        }
        this.game.setePressed(false);
    }

    public void tryToAttack(Graphics g, weapons weapon, ArrayList<Entity> entities) {
        if (System.currentTimeMillis() - this.lastHitTime < GameConstants.getFiringInterval()) {
            return;
        }
        this.lastHitTime = System.currentTimeMillis();
        if (this.game.getDirectionHori().equals("left")) {
            SlashEntity slash = new SlashEntity("sprites/misc/slash.gif", weapon.getX() - 160, weapon.getY(), weapon, 4, this.game);
            entities.add(slash);
            return;
        }
        SlashEntity slash = new SlashEntity("sprites/misc/slash.gif", weapon.getX() + 30, weapon.getY(), weapon, 4, this.game);
        entities.add(slash);
    }

    public void jump() {
        System.out.println("a");
        if (System.currentTimeMillis() - this.lastJumpTime < GameConstants.getJumpInterval()) {
            return;
        }
        this.lastJumpTime = System.currentTimeMillis();
        this.dy = GameConstants.getJumpH();
        this.onGround = false;
    }

    public boolean isOnGround() {
        return this.onGround;
    }
}

