/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class MobBossEntity
extends Entity {
    private double patrolSpeed = 60.0;
    private double chaseSpeed = 80.0;
    private double patrolRange = 120.0;
    private double detectionRange = 50.0;
    private double attackRange = 50.0;
    private boolean slashing = false;
    private long slashStartTime = 0L;
    private final long SLASH_DURATION = 250L;
    private Sprite slashEffect;
    private int barWidth = 80;
    private int barHeight = 10;
    private long radialShootCD = 10000L;
    private long lastRadialShoot = 0L;
    private boolean facingRight = true;
    private long chaseDuration = 2000L;
    private long chaseStart = 0L;
    private boolean chasing = false;
    private long swordCooldown = 700L;
    private long lastSlash = 0L;
    private double startX;
    private Game game;

    public MobBossEntity(String spritePath, double x, double y, Game game) {
        super(spritePath, (int)x, (int)y, 30);
        this.x = x;
        this.y = y;
        this.startX = x;
        this.game = game;
        this.slashEffect = SpriteStore.get().getSprite("sprites/misc/slash.png");
    }

    public void update(long delta, Entity player, ArrayList<Entity> entities) {
        double px = player.getX();
        long now = System.currentTimeMillis();
        double dist = Math.abs(px - this.x);
        if (dist > this.detectionRange) {
            this.patrol(delta);
            this.chasing = false;
            return;
        }
        if (now - this.lastRadialShoot >= this.radialShootCD) {
            this.shootRadial(entities);
            this.lastRadialShoot = now;
        }
        if (!this.chasing) {
            this.chasing = true;
            this.chaseStart = now;
        }
        if (now - this.chaseStart < this.chaseDuration) {
            this.chasePlayer(delta, px);
        } else {
            this.trySlash(player);
            this.chasing = false;
        }
    }

    private void patrol(long delta) {
        this.x += this.patrolSpeed * ((double)delta / 1000.0);
        if (this.x > this.startX + this.patrolRange) {
            this.patrolSpeed = -Math.abs(this.patrolSpeed);
        }
        if (this.x < this.startX - this.patrolRange) {
            this.patrolSpeed = Math.abs(this.patrolSpeed);
        }
    }

    private void chasePlayer(long delta, double px) {
        if (px > this.x) {
            this.x += this.chaseSpeed * ((double)delta / 1000.0);
            this.facingRight = true;
        } else {
            this.x -= this.chaseSpeed * ((double)delta / 1000.0);
            this.facingRight = false;
        }
    }

    private void trySlash(Entity player) {
        long now = System.currentTimeMillis();
        double dx = (double)player.getX() - this.x;
        double dist = Math.abs(dx);
        if (dist < this.attackRange) {
            this.lastSlash = now;
            this.slashing = true;
            this.slashStartTime = now;
            player.setHP(player.getHP() - 1);
            double strength = 250.0;
            double pushDir = dx > 0.0 ? 1 : -1;
            ((PlayerEntity)player).applyKnockback(pushDir * strength, 0.0, 180L);
        }
    }

    private void shootRadial(ArrayList<Entity> entities) {
        double[] angles;
        double cx = this.x + (double)(this.sprite.getWidth() / 2);
        double cy = this.y + (double)(this.sprite.getHeight() / 2);
        double[] dArray = angles = new double[]{0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, 3.9269908169872414, 4.71238898038469, 5.497787143782138};
        int n = angles.length;
        int n2 = 0;
        while (n2 < n) {
            double a = dArray[n2];
            entities.add(new EnemyBullet(cx, cy, cx + Math.cos(a) * 200.0, cy + Math.sin(a) * 200.0, this.game));
            ++n2;
        }
    }

    @Override
    public void draw(Graphics g) {
        int barX = (int)this.x + this.sprite.getWidth() / 2 - this.barWidth / 2;
        int barY = (int)this.y - 15;
        if (this.sprite != null) {
            this.sprite.draw(g, (int)this.x, (int)this.y);
        }
        g.setColor(Color.DARK_GRAY);
        g.fillRect(barX, barY, this.barWidth, this.barHeight);
        float hpRatio = (float)this.getHP() / 30.0f;
        g.setColor(Color.GREEN);
        g.fillRect(barX, barY, (int)((float)this.barWidth * hpRatio), this.barHeight);
        g.setColor(Color.BLACK);
        g.drawRect(barX, barY, this.barWidth, this.barHeight);
        if (this.slashing) {
            long now = System.currentTimeMillis();
            double t = (double)(now - this.slashStartTime) / 250.0;
            if (t <= 1.0) {
                float alpha = (float)(1.0 - t);
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, alpha));
                int cx = (int)this.x + this.sprite.getWidth() / 2;
                int cy = (int)this.y + this.sprite.getHeight() / 2;
                int w = this.slashEffect.getWidth();
                int n = this.slashEffect.getHeight();
            } else {
                this.slashing = false;
            }
        }
    }

    @Override
    public void collidedWith(Entity other) {
        PlayerEntity p;
        if (other instanceof SlashEntity) {
            this.setHP(this.getHP() - 1);
        }
        if (other instanceof PlayerEntity && !(p = (PlayerEntity)other).isInvincible()) {
            p.setHP(p.getHP() - 1);
            p.setInvincible(true);
            p.setLastHitTime(System.currentTimeMillis());
        }
        if (this.getHP() <= 0) {
            this.game.removeEntity(this);
        }
    }
}

