/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class KeyInputHandler
extends KeyAdapter {
    private Game game;
    private GameStates state;
    private GameStates lastState;
    private int pressCount = 1;

    public KeyInputHandler(Game game, GameStates state) {
        this.game = game;
        this.state = state;
        this.lastState = state;
    }

    public void setState(GameStates state) {
        this.state = state;
    }

    public GameStates getState() {
        return this.state;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        block0 : switch (this.state) {
            case Menu: {
                switch (e.getKeyCode()) {
                    case 10: {
                        this.state = GameStates.Game;
                        this.game.setStates(this.state);
                        this.game.startGame();
                        break;
                    }
                    case 9: {
                        this.lastState = GameStates.Menu;
                        this.state = GameStates.Controls;
                        this.game.setStates(this.state);
                        break;
                    }
                    case 16: {
                        this.state = GameStates.Story;
                        this.game.setStates(this.state);
                    }
                }
                break;
            }
            case Paused: {
                switch (e.getKeyCode()) {
                    case 80: {
                        this.lastState = this.state;
                        this.state = GameStates.Game;
                        this.game.setStates(this.state);
                        break;
                    }
                    case 9: {
                        System.out.println("a");
                        this.lastState = GameStates.Paused;
                        this.state = GameStates.Controls;
                        this.game.setStates(this.state);
                    }
                }
                break;
            }
            case Story: {
                if (e.getKeyCode() != 8) break;
                this.state = GameStates.Menu;
                this.game.setStates(this.state);
                break;
            }
            case Controls: {
                if (e.getKeyCode() != 8) break;
                System.out.println((Object)this.lastState);
                this.game.setStates(this.lastState);
                break;
            }
            case Ending: {
                if (e.getKeyCode() != 10) break;
                this.state = GameStates.Menu;
                this.game.getTileM().changeStage(1);
                this.game.setStates(this.state);
                break;
            }
            case Dead: {
                if (e.getKeyCode() != 10) break;
                this.state = GameStates.Menu;
                this.game.setStates(this.state);
                break;
            }
            default: {
                switch (e.getKeyCode()) {
                    case 65: {
                        this.game.setLeftPressed(true);
                        this.game.setDirectionHori("left");
                        break block0;
                    }
                    case 68: {
                        this.game.setRightPressed(true);
                        this.game.setDirectionHori("right");
                        break block0;
                    }
                    case 87: {
                        if (!this.game.isObsticleNotAbove()) break block0;
                        this.game.setJump(true);
                        this.game.setDirectionVert("up");
                        break block0;
                    }
                    case 32: {
                        this.game.setFirePressed(true);
                        break block0;
                    }
                    case 69: {
                        this.game.setePressed(true);
                        break block0;
                    }
                    case 80: {
                        this.lastState = this.state;
                        this.state = GameStates.Paused;
                        this.game.setStates(this.state);
                    }
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.state == GameStates.Game) {
            switch (e.getKeyCode()) {
                case 65: {
                    this.game.setLeftPressed(false);
                    break;
                }
                case 68: {
                    this.game.setRightPressed(false);
                    break;
                }
                case 87: {
                    this.game.setJump(false);
                    break;
                }
                case 32: {
                    this.game.setFirePressed(false);
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\u001b') {
            System.exit(0);
        }
    }
}

