/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Game
extends Canvas {
    private BufferStrategy strategy;
    private boolean gameRunning = true;
    private boolean obsticleNotAbove = true;
    private boolean debounceTileAbove = true;
    private boolean obsticleLateralLeft = false;
    private boolean obsticleLateralRight = false;
    private GameStates currentStates;
    private int[] playerSpawnsX = GameConstants.getPlayerSpawnX();
    private int[] playerSpawnsY = GameConstants.getPlayerSpawnY();
    private int[] eliteSpawnY = GameConstants.getEliteSpawnY();
    private int[][] map;
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    private boolean ePressed = false;
    private boolean firePressed = false;
    private boolean jump = false;
    private String directionHori = "right";
    private String directionVert = "down";
    private ArrayList<EliteMobEntity> elites = new ArrayList();
    private ArrayList<MobEntity> mobs = new ArrayList();
    private ArrayList<Entity> entities = new ArrayList();
    private ArrayList<Entity> removeEntities = new ArrayList();
    private ArrayList<Tiles> tiles;
    private ArrayList<EnemyBullet> enemyBullets = new ArrayList();
    private Entity player;
    private weapons weapon;
    private TileManager tileM = new TileManager(this);
    private MobEntity mob;
    private MobBossEntity boss;
    private SceneManager SM;
    private KeyInputHandler ki;
    private int height = GameConstants.getHeight();
    private int width = GameConstants.getWidth();

    public Game() {
        JFrame container = new JFrame("CrimsonRidge");
        JPanel panel = (JPanel)container.getContentPane();
        panel.setPreferredSize(new Dimension(this.width, this.height));
        panel.setLayout(null);
        this.currentStates = GameStates.Menu;
        this.setBounds(0, 0, this.width, this.height);
        panel.add(this);
        this.setIgnoreRepaint(true);
        container.pack();
        container.setResizable(false);
        container.setVisible(true);
        container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.ki = new KeyInputHandler(this, this.currentStates);
        this.addKeyListener(this.ki);
        this.SM = new SceneManager(this, this.currentStates);
        this.requestFocus();
        this.setFocusTraversalKeysEnabled(false);
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
        this.initEntities();
        this.gameLoop();
    }

    public void initEntities() {
        this.tiles = this.getTileM().getTileArr();
        this.player = new PlayerEntity(this, "sprites/Entity/hero1stand.png", this.playerSpawnsX[this.tileM.getStage() - 1] * GameConstants.getTilesize(), this.playerSpawnsY[this.tileM.getStage() - 1] * GameConstants.getTilesize());
        this.entities.add(this.player);
        this.weapon = new weapons("sprites/misc/sword.png", this.player.getX(), this.player.getY(), 1, this.player);
        this.loadLevel();
    }

    public void removeEntity(Entity entity) {
        this.removeEntities.add(entity);
    }

    public void checkHP(Entity e) {
        if (e.getHP() <= 0) {
            this.removeEntities.add(e);
            if (e instanceof PlayerEntity) {
                this.notifyDeath();
            }
        }
    }

    public void notifyDeath() {
        this.currentStates = GameStates.Dead;
    }

    public void notifyWin() {
        this.currentStates = GameStates.Ending;
    }

    public void gameLoop() {
        long lastLoopTime = System.currentTimeMillis();
        this.map = this.getTileM().getMap();
        while (this.gameRunning) {
            long delta = System.currentTimeMillis() - lastLoopTime;
            lastLoopTime = System.currentTimeMillis();
            Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
            g.setColor(GameConstants.getTransParent());
            g.fillRect(0, 0, this.width, this.height);
            switch (this.currentStates) {
                case Menu: {
                    this.SM.set(this.currentStates);
                    this.ki.setState(this.currentStates);
                    this.SM.draw(g);
                    break;
                }
                case Game: {
                    Object entity;
                    if (this.boss != null && this.boss.getHP() > 0) {
                        this.boss.update(delta, this.player, this.entities);
                    }
                    for (EliteMobEntity e : this.elites) {
                        e.update(delta, this.player, this.entities);
                    }
                    this.getTileM().drawBG(g);
                    this.weapon.draw(g, this.getDirectionHori());
                    this.weapon.move();
                    this.player.boundToTileIndex();
                    int i = 0;
                    while (i < this.entities.size()) {
                        entity = this.entities.get(i);
                        ((Entity)entity).move(delta);
                        ++i;
                    }
                    for (EnemyBullet b : this.enemyBullets) {
                        b.move(delta);
                    }
                    for (EnemyBullet b : this.enemyBullets) {
                        b.draw(g);
                    }
                    i = 0;
                    while (i < this.getEntities().size()) {
                        entity = this.getEntities().get(i);
                        this.checkHP((Entity)entity);
                        if (entity instanceof PlayerEntity) {
                            PlayerEntity e = (PlayerEntity)entity;
                            e.draw(g, this.getDirectionVert(), this.getDirectionHori(), 'o');
                        } else if (entity instanceof SlashEntity) {
                            ((Entity)entity).draw(g, this.getDirectionHori());
                        } else if (entity instanceof MobEntity) {
                            ((Entity)entity).draw(g);
                        } else {
                            ((Entity)entity).draw(g);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.entities.size()) {
                        int j = i + 1;
                        while (j < this.entities.size()) {
                            Entity him;
                            Entity me = this.entities.get(i);
                            if (me.collidesWith(him = this.entities.get(j))) {
                                me.collidedWith(him);
                                him.collidedWith(me);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    for (Entity e : this.entities) {
                        e.boundToTileIndex();
                    }
                    this.entities.removeAll(this.removeEntities);
                    this.removeEntities.clear();
                    this.player.setHorizontalMovement(0.0);
                    if (this.isLeftPressed() && !this.isRightPressed()) {
                        this.player.setHorizontalMovement((double)(-GameConstants.getMovespeed()) * (((PlayerEntity)this.player).isOnGround() ? 1.0 : 0.4));
                    } else if (this.isRightPressed() && !this.isLeftPressed()) {
                        this.player.setHorizontalMovement((double)GameConstants.getMovespeed() * (((PlayerEntity)this.player).isOnGround() ? 1.0 : 0.4));
                    }
                    if (this.firePressed) {
                        ((PlayerEntity)this.player).tryToAttack(g, this.weapon, this.entities);
                    }
                    if (this.ePressed) {
                        ((PlayerEntity)this.player).tryToDash();
                    }
                    if (!this.jump) break;
                    ((PlayerEntity)this.player).jump();
                    this.jump = false;
                    break;
                }
                case Paused: 
                case Story: 
                case Ending: 
                case Controls: 
                case Dead: {
                    this.SM.set(this.currentStates);
                    this.ki.setState(this.currentStates);
                    this.SM.draw(g);
                    break;
                }
            }
            g.dispose();
            this.strategy.show();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadLevel() {
        int spawnY;
        int spawnX;
        ArrayList<Entity> toRemove = new ArrayList<Entity>();
        for (Entity e : this.entities) {
            if (!(e instanceof MobEntity) && !(e instanceof EliteMobEntity) && !(e instanceof MobBossEntity) && !(e instanceof SlashEntity) && !(e instanceof EnemyBullet)) continue;
            toRemove.add(e);
        }
        this.entities.removeAll(toRemove);
        this.mobs.clear();
        this.elites.clear();
        this.enemyBullets.clear();
        this.boss = null;
        int difficulty = this.tileM.getStage();
        int mobCount = difficulty > 1 || difficulty == 4 ? 4 : 2;
        int eliteCount = difficulty == 4 ? 1 : 2;
        int i = 0;
        while (i < mobCount) {
            spawnX = 200 + i * 150;
            spawnY = GameConstants.getHeight() - 400 + i * 40;
            MobEntity m = new MobEntity("sprites/Entity/EyeB.png", spawnX, spawnY);
            this.entities.add(m);
            this.mobs.add(m);
            ++i;
        }
        if (this.tileM.getStage() > 1) {
            i = 0;
            while (i < eliteCount) {
                spawnX = difficulty == 4 ? 3 * GameConstants.getTilesize() : 300 + i * 250;
                spawnY = this.eliteSpawnY[difficulty - 1] * GameConstants.getTilesize();
                System.out.println(spawnY);
                EliteMobEntity e = new EliteMobEntity("sprites/Entity/Elite.png", spawnX, spawnY, this);
                this.entities.add(e);
                this.elites.add(e);
                ++i;
            }
        }
        if (difficulty == 4) {
            this.boss = new MobBossEntity("sprites/Entity/boss.png", 900.0, (double)(GameConstants.getHeight() - 350), this);
            this.entities.add(this.boss);
        }
        this.ePressed = false;
        this.jump = false;
        this.firePressed = false;
        this.rightPressed = false;
        this.leftPressed = false;
    }

    public void startGame() {
        this.entities.clear();
        this.initEntities();
        this.setLeftPressed(false);
        this.setRightPressed(false);
        this.setJump(false);
        this.setFirePressed(false);
    }

    public boolean isFirePressed() {
        return this.firePressed;
    }

    public void setFirePressed(boolean firePressed) {
        this.firePressed = firePressed;
    }

    public void setStates(GameStates s) {
        this.currentStates = s;
    }

    public GameStates getStates() {
        return this.currentStates;
    }

    public boolean isJump() {
        return this.jump;
    }

    public void setJump(boolean jump) {
        this.jump = jump;
    }

    public boolean isRightPressed() {
        return this.rightPressed;
    }

    public void setRightPressed(boolean rightPressed) {
        this.rightPressed = rightPressed;
    }

    public boolean isLeftPressed() {
        return this.leftPressed;
    }

    public void setLeftPressed(boolean leftPressed) {
        this.leftPressed = leftPressed;
    }

    public String getDirectionHori() {
        return this.directionHori;
    }

    public void setDirectionHori(String directionHori) {
        this.directionHori = directionHori;
    }

    public String getDirectionVert() {
        return this.directionVert;
    }

    public void setDirectionVert(String directionVert) {
        this.directionVert = directionVert;
    }

    public boolean isObsticleNotAbove() {
        return this.obsticleNotAbove;
    }

    public void setObsticleNotAbove(boolean obsticleNotAbove) {
        this.obsticleNotAbove = obsticleNotAbove;
    }

    public boolean isePressed() {
        return this.ePressed;
    }

    public void setePressed(boolean ePressed) {
        this.ePressed = ePressed;
    }

    public ArrayList<Tiles> getTileList() {
        return this.tiles;
    }

    public TileManager getTileManager() {
        return this.getTileM();
    }

    public int[][] getMap() {
        return this.map;
    }

    public TileManager getTileM() {
        return this.tileM;
    }

    public void setTileM(TileManager tileM) {
        this.tileM = tileM;
    }

    public boolean isDebounceTileAbove() {
        return this.debounceTileAbove;
    }

    public void setDebounceTileAbove(boolean debounceTileAbove) {
        this.debounceTileAbove = debounceTileAbove;
    }

    public ArrayList<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(ArrayList<Entity> entities) {
        this.entities = entities;
    }

    public static void main(String[] args) {
        new Game();
    }
}

