/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class Entity {
    protected double x;
    protected double y;
    protected double dx;
    protected double dy;
    public Sprite sprite;
    private boolean isGrounded = false;
    private int HP;
    private int boundingLeft;
    private int boundingRight;
    private int boundingTop;
    private int boundingBottom;
    private int boundingMid;
    public Rectangle me = new Rectangle();
    public Rectangle him = new Rectangle();

    public Entity(String r, int newX, int newY, int HP) {
        this.x = newX;
        this.y = newY;
        this.HP = HP;
        this.sprite = SpriteStore.get().getSprite(r);
    }

    public void move(long delta) {
        this.x += (double)delta * this.dx / 1000.0;
        this.y += (double)delta * this.dy / 1000.0;
    }

    public void setHorizontalMovement(double newDX) {
        this.dx = newDX;
    }

    public void setVerticalMovement(double newDY) {
        this.dy = newDY;
    }

    public double getHorizontalMovement() {
        return this.dx;
    }

    public double getVerticalMovement() {
        return this.dy;
    }

    public int getX() {
        return (int)this.x;
    }

    public int getY() {
        return (int)this.y;
    }

    public void setX(int X) {
        this.x = X;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public boolean getIsGrounded() {
        return this.isGrounded;
    }

    public void setIsGrounded(boolean grounded) {
        this.isGrounded = grounded;
    }

    public int getHP() {
        return this.HP;
    }

    public void setHP(int hp) {
        this.HP = hp;
    }

    public void draw(Graphics g, String dir) {
        this.sprite.draw(g, (int)this.x, (int)this.y, dir);
    }

    public void draw(Graphics g) {
        g.fillRect(this.getX(), this.getY(), this.sprite.getWidth(), this.sprite.getHeight());
        this.sprite.draw(g, (int)this.x, (int)this.y);
    }

    public void doLogic() {
    }

    public boolean collidesWith(Entity other) {
        this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
        this.him.setBounds(other.getX(), other.getY(), other.sprite.getWidth(), other.sprite.getHeight());
        return this.me.intersects(this.him);
    }

    public boolean wallCollisons(Tiles wall) {
        this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
        return this.me.intersects(wall.getBounds());
    }

    public Rectangle getAbsoulteBounds() {
        this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
        return this.me;
    }

    public int getEWidth() {
        return this.sprite.getWidth();
    }

    public int getEHeight() {
        return this.sprite.getHeight();
    }

    public void boundToTileIndex() {
        this.setBoundingLeft((int)Math.floor(this.x / (double)GameConstants.getTilesize()));
        this.setBoundingRight((int)Math.floor((this.x + (double)this.sprite.getWidth()) / (double)GameConstants.getTilesize()));
        this.setBoundingTop((int)Math.floor(this.y / (double)GameConstants.getTilesize()));
        this.setBoundingBottom((int)Math.floor((this.y + (double)this.sprite.getHeight()) / (double)GameConstants.getTilesize()));
        this.setBoundingMid((this.boundingTop + this.boundingBottom) / 2);
    }

    public abstract void collidedWith(Entity var1);

    public int getBoundingLeft() {
        return this.boundingLeft;
    }

    public void setBoundingLeft(int boundingLeft) {
        this.boundingLeft = boundingLeft;
    }

    public int getBoundingRight() {
        return this.boundingRight;
    }

    public void setBoundingRight(int boundingRight) {
        this.boundingRight = boundingRight;
    }

    public int getBoundingTop() {
        return this.boundingTop;
    }

    public void setBoundingTop(int boundingTop) {
        this.boundingTop = boundingTop;
    }

    public int getBoundingBottom() {
        return this.boundingBottom;
    }

    public void setBoundingBottom(int boundingBottom) {
        this.boundingBottom = boundingBottom;
    }

    public int getBoundingMid() {
        return this.boundingMid;
    }

    public void setBoundingMid(int boundingMid) {
        this.boundingMid = boundingMid;
    }
}

