/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class EnemyBullet
extends Entity {
    private boolean alive = true;
    private double speed = 250.0;
    private Game game;

    public EnemyBullet(double sx, double sy, double tx, double ty, Game g) {
        super("sprites/misc/shot.gif", (int)sx, (int)sy, 1);
        this.game = g;
        double dx = tx - sx;
        double dy = ty - sy;
        double len = Math.sqrt(dx * dx + dy * dy);
        this.setHorizontalMovement(dx / len * this.speed);
        this.setVerticalMovement(dy / len * this.speed);
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (this.x < 0.0 || this.x > 2000.0 || this.y < 0.0 || this.y > 2000.0) {
            this.alive = false;
            this.game.removeEntity(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collidedWith(Entity other) {
        Entity entity = other;
        if (entity instanceof PlayerEntity) {
            void player;
            PlayerEntity playerEntity = (PlayerEntity)entity;
            PlayerEntity cfr_ignored_0 = (PlayerEntity)entity;
            player.setHP(player.getHP() - 1);
            this.alive = false;
            this.game.removeEntity(this);
        }
    }

    public void draw(Graphics2D g) {
        g.setColor(GameConstants.getTransParent());
        g.fillOval((int)this.x, (int)this.y, 10, 10);
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.x, (int)this.y, 10, 10);
    }

    public boolean isAlive() {
        return this.alive;
    }
}

