/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.util.ArrayList;

public class EliteMobEntity
extends Entity {
    private double vx = 80.0;
    private double patrolRange = 30.0;
    private double startX;
    private Game game;
    private long lastShot = 0L;
    private long shootInterval = 800L;
    private EnemyBullet currentBullet = null;
    private boolean bulletAlive = false;

    public EliteMobEntity(String spritePath, int x, int y, Game g) {
        super(spritePath, x, y, 10);
        this.x = x;
        this.y = y;
        this.startX = x;
        this.game = g;
    }

    public void update(long delta, Entity player, ArrayList<Entity> entities) {
        double px;
        double dist;
        if (this.currentBullet != null && !this.currentBullet.isAlive()) {
            this.bulletAlive = false;
            this.currentBullet = null;
        }
        this.x += this.vx * ((double)delta / 1000.0);
        if (this.x > this.startX + this.patrolRange) {
            this.vx = -this.vx;
        }
        if (this.x < this.startX - this.patrolRange) {
            this.vx = -this.vx;
        }
        if ((dist = Math.abs((px = (double)player.getX()) - this.x)) < 400.0) {
            this.tryShoot(px, player.getY(), entities);
        }
    }

    private void tryShoot(double px, double py, ArrayList<Entity> entities) {
        long now = System.currentTimeMillis();
        if (now - this.lastShot < this.shootInterval) {
            return;
        }
        if (this.bulletAlive) {
            return;
        }
        this.lastShot = now;
        this.currentBullet = new EnemyBullet(this.x + (double)(this.sprite.getWidth() / 2), this.y + (double)(this.sprite.getHeight() / 2), px, py, this.game);
        this.bulletAlive = true;
        entities.add(this.currentBullet);
    }

    public void draw(Graphics2D g) {
        if (this.sprite != null) {
            this.sprite.draw(g, (int)this.x, (int)this.y);
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof SlashEntity) {
            this.setHP(0);
            this.game.removeEntity(this);
        }
    }
}

