/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class Spike {
    private int x;
    private int y;
    private int width;
    private int height;
    private Rectangle hitbox;
    private Sprite spikeSprite;

    public Spike(int x, int y, int TILES_DEFAULT_SIZE, int height) {
        this.x = x;
        this.y = y + TILES_DEFAULT_SIZE / 2;
        this.width = TILES_DEFAULT_SIZE;
        this.height = TILES_DEFAULT_SIZE / 2;
        this.loadSpikeImage();
        this.hitbox = new Rectangle(x, y + TILES_DEFAULT_SIZE / 2, TILES_DEFAULT_SIZE, TILES_DEFAULT_SIZE / 2);
    }

    public void draw(Graphics2D gtd, int xLvlOffset) {
        if (this.spikeSprite != null) {
            this.spikeSprite.draw(gtd, this.x - xLvlOffset, this.y - 20);
        }
    }

    private void loadSpikeImage() {
        this.spikeSprite = SpriteStore.get().getSprite("sprites/trap.png");
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getHitBox() {
        return this.hitbox;
    }
}

