/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class Portal {
    private int TILE_SIZE = 50;
    private int x;
    private int y;
    private int width;
    private int height;
    private Sprite[] frames = this.loadFrames();
    private int frameIndex = 0;
    private long lastFrameTime = 0L;
    private long frameDelay = 100L;
    private Rectangle hitbox;
    private Sprite portal;

    public Portal(int x, int y) {
        this.x = x;
        this.y = y;
        this.width = this.frames[0].getWidth();
        this.height = this.frames[0].getHeight();
        int hitboxWidth = this.width - 40;
        int hitboxHeight = this.height - 20;
        this.hitbox = new Rectangle(x + 40, y + this.height / 2, hitboxWidth, hitboxHeight);
    }

    private Sprite[] loadFrames() {
        int count = 8;
        String location = "sprites/animations/end_portal/end_portal";
        Sprite[] frames = new Sprite[count];
        int i = 0;
        while (i < count) {
            String ref = String.valueOf(location) + (i + 1) + ".png";
            frames[i] = SpriteStore.get().getSprite(ref);
            ++i;
        }
        return frames;
    }

    public void draw(Graphics2D gtd, int xLvlOffset) {
        this.updateFrame();
        this.portal = this.frames[this.frameIndex];
        int drawWidth = (int)((float)this.portal.getWidth() * 1.75f);
        int drawHeight = (int)((float)this.portal.getHeight() * 1.75f);
        gtd.drawImage(this.portal.getImage(), this.x - xLvlOffset, this.y, drawWidth, drawHeight, null);
    }

    private void updateFrame() {
        long now = System.currentTimeMillis();
        if (now - this.lastFrameTime > this.frameDelay) {
            this.lastFrameTime = now;
            this.frameIndex = (this.frameIndex + 1) % this.frames.length;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getHitbox() {
        return this.hitbox;
    }
}

