/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

public class Player
extends Entity {
    private Game game;
    protected double dx = 0.0;
    protected double dy = 0.0;
    private boolean onGround = true;
    private static final double GRAVITY = 1500.0;
    private static final double JUMP_STRENGTH = -500.0;
    private boolean takenFallDamage = false;
    private double impactSpeed = 0.0;
    private int hitboxWidth = 42;
    private int hitboxHeight = 66;
    private int offsetX = 0;
    private int offsetY = 0;
    private long lastDamageTimeSpike = 0L;
    private long damageCooldownSpike = 500L;
    private boolean animationFinished = false;
    private boolean facingRight = true;
    private Sprite[] idleFrames;
    private Sprite[] runFrames;
    private Sprite[] jumpFrames;
    private Sprite[] fallFrames;
    private Sprite[] portalFrames;
    private Sprite[] deathFrames;
    private Sprite[] hurtFrames;
    private int animationIndex = 1;
    private long lastFrameTime = 0L;
    private long frameSpeed = 100L;
    public PlayerState state = PlayerState.IDLE;
    private final double FALL_DAMAGE_THRESHOLD = 800.0;

    public Player(Game g, String r, int newX, int newY) {
        super(r, newX, newY);
        this.game = g;
        this.loadAnimations();
        this.currentHealth = this.maxHealth = 100;
        this.healthWidth = this.game.healthBarWidth;
        this.offsetX = (int)((float)this.sprite.getWidth() * 1.75f - (float)this.hitboxWidth) / 2;
        this.offsetY = (int)((float)this.sprite.getHeight() * 1.75f - (float)this.hitboxHeight) / 2;
        this.me.setBounds((int)this.x, (int)this.y, this.hitboxWidth, this.hitboxHeight);
    }

    @Override
    public void printAnimationDebug() {
        System.out.println("State: " + (Object)((Object)this.state) + ", Index: " + this.animationIndex + ", Finished: " + this.animationFinished + ", dy: " + this.dy + ", onGround: " + this.onGround);
    }

    private void loadAnimations() {
        this.idleFrames = this.loadFrames("sprites/animations/idle/idle", 7);
        this.jumpFrames = this.loadFrames("sprites/animations/jump/jump", 2);
        this.fallFrames = this.loadFrames("sprites/animations/fall/fall", 3);
        this.portalFrames = this.loadFrames("sprites/animations/portal/portal", 20);
        this.runFrames = this.loadFrames("sprites/animations/run/run", 8);
        this.deathFrames = this.loadFrames("sprites/animations/death/death", 12);
        this.hurtFrames = this.loadFrames("sprites/animations/hurt/hurt", 4);
    }

    private void updateAnimationState() {
        PlayerState previous = this.state;
        if (this.state == PlayerState.DEATH) {
            return;
        }
        if (this.state == PlayerState.HURT && !this.animationFinished) {
            return;
        }
        if (this.game.isShifting()) {
            this.state = PlayerState.PORTAL;
        } else if (!this.onGround) {
            if (this.dy < 0.0) {
                this.state = PlayerState.JUMP;
            } else if (this.dy > 0.0) {
                this.state = PlayerState.FALL;
            }
        } else {
            this.state = Math.abs(this.dx) > 0.1 ? PlayerState.RUN : PlayerState.IDLE;
        }
        if (this.state != previous) {
            this.animationIndex = 1;
            this.animationFinished = false;
            this.lastFrameTime = System.currentTimeMillis();
        }
    }

    public Sprite getCurrentAnimationFrame() {
        switch (this.state) {
            case IDLE: {
                return this.idleFrames[this.animationIndex % this.idleFrames.length];
            }
            case RUN: {
                return this.runFrames[this.animationIndex % this.runFrames.length];
            }
            case JUMP: {
                return this.jumpFrames[this.animationIndex];
            }
            case FALL: {
                return this.fallFrames[this.animationIndex];
            }
            case PORTAL: {
                return this.portalFrames[this.animationIndex % this.portalFrames.length];
            }
            case DEATH: {
                return this.deathFrames[this.animationIndex];
            }
            case HURT: {
                return this.hurtFrames[this.animationIndex];
            }
        }
        return this.idleFrames[1];
    }

    private void updateAnimationFrame() {
        long now = System.currentTimeMillis();
        if (now - this.lastFrameTime > this.frameSpeed) {
            this.lastFrameTime = now;
            if (this.state == PlayerState.JUMP || this.state == PlayerState.FALL || this.state == PlayerState.HURT || this.state == PlayerState.DEATH) {
                if (!this.animationFinished) {
                    ++this.animationIndex;
                    int frameCount = this.getCurrentFrameCount();
                    if (this.animationIndex >= frameCount - 1) {
                        this.animationIndex = frameCount - 1;
                        this.animationFinished = true;
                    }
                }
            } else {
                ++this.animationIndex;
            }
        }
    }

    private int getCurrentFrameCount() {
        return switch (this.state) {
            case PlayerState.IDLE -> this.idleFrames.length;
            case PlayerState.RUN -> this.runFrames.length;
            case PlayerState.JUMP -> this.jumpFrames.length;
            case PlayerState.FALL -> this.fallFrames.length;
            case PlayerState.PORTAL -> this.portalFrames.length;
            case PlayerState.DEATH -> this.deathFrames.length;
            case PlayerState.HURT -> this.hurtFrames.length;
            default -> throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)this.state));
        };
    }

    @Override
    public void draw(Graphics g, int xLvlOffset) {
        Sprite current = this.getCurrentAnimationFrame();
        int drawX = (int)this.x - this.offsetX - xLvlOffset;
        int drawY = (int)this.y - this.offsetY;
        int drawWidth = (int)((float)current.getWidth() * 1.75f);
        int drawHeight = (int)((float)current.getHeight() * 1.75f);
        if (!this.facingRight) {
            g.drawImage(current.getImage(), drawX + (int)((float)this.sprite.getWidth() * 1.75f), drawY, -drawWidth, drawHeight, null);
        } else {
            g.drawImage(current.getImage(), drawX, drawY, drawWidth, drawHeight, null);
        }
    }

    private Sprite[] loadFrames(String location, int count) {
        Sprite[] frames = new Sprite[count];
        int i = 0;
        while (i < count) {
            String ref = String.valueOf(location) + (i + 1) + ".png";
            frames[i] = SpriteStore.get().getSprite(ref);
            ++i;
        }
        return frames;
    }

    @Override
    public boolean atPortal() {
        Portal portal = this.game.getPortal();
        if (portal == null) {
            return false;
        }
        return this.me.intersects(portal.getHitbox());
    }

    @Override
    public void dmgChecker() {
        if (this.state == PlayerState.DEATH) {
            return;
        }
        if (this.onGround) {
            this.takenFallDamage = false;
        }
        if (this.y > (double)(784 + 50)) {
            this.changeHealth(-this.maxHealth);
        }
        for (Spike spike : this.game.getSpikes()) {
            if (!this.me.intersects(spike.getHitBox())) continue;
            this.takeSpikeDamage(-10);
        }
    }

    @Override
    public void updateHealthBar() {
        this.healthWidth = (int)((double)this.currentHealth / (double)this.maxHealth * (double)this.game.healthBarWidth);
    }

    private void changeHealth(int value) {
        if (value < 0) {
            this.currentHealth += value;
            this.currentHealth = Math.max(Math.min(this.currentHealth, this.maxHealth), 0);
            this.state = PlayerState.HURT;
            this.animationIndex = 0;
            this.animationFinished = false;
            if (this.currentHealth <= 0) {
                this.state = PlayerState.DEATH;
                this.animationIndex = 0;
                this.animationFinished = false;
                this.game.notifyDeath();
            }
        }
        this.updateHealthBar();
    }

    @Override
    public void takeSpikeDamage(int value) {
        long now = System.currentTimeMillis();
        if (now - this.lastDamageTimeSpike < this.damageCooldownSpike) {
            return;
        }
        this.lastDamageTimeSpike = now;
        this.changeHealth(value);
    }

    @Override
    public void move(long delta) {
        this.updateAnimationState();
        this.updateAnimationFrame();
        if (this.state == PlayerState.DEATH) {
            return;
        }
        if (this.game.isShifting()) {
            for (Platform platform : this.game.getPlatforms()) {
                if (!this.me.intersects(platform.hitBox) || !(this.dy > 0.0)) continue;
                this.y = platform.y - this.me.height;
                this.dy = 0.0;
                this.onGround = true;
                this.me.setLocation((int)this.x, (int)this.y);
                break;
            }
            return;
        }
        this.x += this.dx * (double)delta / 1000.0;
        this.me.setLocation((int)this.x, (int)this.y);
        for (Platform platform : this.game.getPlatforms()) {
            if (!this.me.intersects(platform.hitBox)) continue;
            if (this.dx > 0.0) {
                this.x = platform.x - this.me.width;
            } else if (this.dx < 0.0) {
                this.x = platform.x + platform.width;
            }
            this.me.setLocation((int)this.x, (int)this.y);
            break;
        }
        if (!this.onGround) {
            this.dy += 1500.0 * (double)delta / 1000.0;
        }
        this.y += this.dy * (double)delta / 1000.0;
        this.me.setLocation((int)this.x, (int)this.y);
        for (Platform platform : this.game.getPlatforms()) {
            if (!this.me.intersects(platform.hitBox)) continue;
            if (this.dy > 0.0) {
                this.impactSpeed = this.dy;
                if (this.impactSpeed > 800.0 && !this.takenFallDamage) {
                    int damage = (int)((this.impactSpeed - 800.0) / 25.0);
                    if (damage < 1) {
                        damage = 1;
                    }
                    this.changeHealth(-damage);
                    this.takenFallDamage = true;
                }
                this.y = platform.y - this.me.height;
                this.dy = 0.0;
                this.me.setLocation((int)this.x, (int)this.y);
                continue;
            }
            if (!(this.dy < 0.0)) continue;
            this.y = platform.y + platform.height;
            this.dy = 0.0;
            this.me.setLocation((int)this.x, (int)this.y);
        }
        boolean grounded = false;
        for (Platform platform : this.game.getPlatforms()) {
            boolean feetClose;
            boolean horizontalMatch = this.x + (double)this.me.width > (double)platform.x && this.x < (double)(platform.x + platform.width);
            boolean bl = feetClose = Math.abs(this.y + (double)this.me.height - (double)platform.y) <= 2.0;
            if (!horizontalMatch || !feetClose) continue;
            grounded = true;
            break;
        }
        this.onGround = grounded;
        if (this.onGround) {
            this.takenFallDamage = false;
        }
        this.me.setLocation((int)this.x, (int)this.y);
    }

    @Override
    public boolean isOnGround() {
        return this.onGround;
    }

    @Override
    public void jump() {
        if (this.onGround) {
            this.onGround = false;
            this.dy = -500.0;
        }
    }

    @Override
    public void setHorizontalMovement(double dx) {
        this.dx = dx;
        if (dx > 0.0) {
            this.facingRight = true;
        }
        if (dx < 0.0) {
            this.facingRight = false;
        }
    }

    @Override
    public void setVerticalMovement(double newDY) {
        this.dy = newDY;
    }

    @Override
    public boolean animationDone() {
        return this.animationFinished;
    }

    @Override
    public void collidedWith(Entity other) {
    }

    public static enum PlayerState {
        IDLE,
        RUN,
        JUMP,
        FALL,
        PORTAL,
        HURT,
        DEATH;

    }
}

