/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class Platform {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private BufferedImage[] tileSprite;
    private BufferedImage[] shiftedTileSprite;
    private int spriteIndex;
    protected Rectangle hitBox;

    public Platform(int x, int y, int TILES_DEFAULT_SIZE, int height, int spriteIndex) {
        this.x = x;
        this.y = y;
        this.width = TILES_DEFAULT_SIZE;
        this.height = TILES_DEFAULT_SIZE;
        this.spriteIndex = spriteIndex;
        this.importOutsideSprites();
        this.spriteIndex = spriteIndex - 1;
        this.hitBox = new Rectangle(x, y, TILES_DEFAULT_SIZE, TILES_DEFAULT_SIZE);
    }

    public void draw(Graphics2D gtd, int xLvlOffset, boolean shifted) {
        if (this.spriteIndex >= 0 && this.spriteIndex < this.shiftedTileSprite.length && this.shiftedTileSprite[this.spriteIndex] != null && shifted) {
            gtd.drawImage(this.shiftedTileSprite[this.spriteIndex], this.x - xLvlOffset, this.y, this.width, this.height, null);
        } else {
            gtd.drawImage(this.tileSprite[this.spriteIndex], this.x - xLvlOffset, this.y, this.width, this.height, null);
        }
    }

    private void importOutsideSprites() {
        Sprite sprite = SpriteStore.get().getSprite("sprites/outside_sprites.png");
        Sprite sprite2 = SpriteStore.get().getSprite("sprites/outside_sprites_shifted.png");
        BufferedImage img = new BufferedImage(sprite.getWidth(), sprite.getHeight(), 2);
        BufferedImage img2 = new BufferedImage(sprite2.getWidth(), sprite2.getHeight(), 2);
        Graphics2D g = img.createGraphics();
        Graphics2D g2 = img2.createGraphics();
        g.drawImage(sprite.getImage(), 0, 0, null);
        g2.drawImage(sprite2.getImage(), 0, 0, null);
        g2.dispose();
        g.dispose();
        this.shiftedTileSprite = new BufferedImage[48];
        this.tileSprite = new BufferedImage[48];
        int j = 0;
        while (j < 4) {
            int i = 0;
            while (i < 12) {
                int index = j * 12 + i;
                this.tileSprite[index] = img.getSubimage(i * 32, j * 32, 32, 32);
                this.shiftedTileSprite[index] = img2.getSubimage(i * 32, j * 32, 32, 32);
                ++i;
            }
            ++j;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

