/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Rectangle;

public class Button {
    private int x;
    private int y;
    private int width;
    private int height;
    private Sprite normalSprite;
    private Sprite hoveredSprite;
    private String buttonType;
    private Rectangle bounds;
    private boolean mouseOver;

    public Button(String r, String s, int x, int y) {
        this.normalSprite = SpriteStore.get().getSprite(r);
        this.hoveredSprite = SpriteStore.get().getSprite(s);
        this.x = x;
        this.y = y;
        this.width = this.normalSprite.getWidth();
        this.height = this.normalSprite.getHeight();
        this.buttonType = r;
        this.initBounds();
    }

    private void initBounds() {
        this.bounds = new Rectangle(this.x, this.y, this.normalSprite.getWidth(), this.normalSprite.getHeight());
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void draw(Graphics g) {
        if (this.mouseOver) {
            this.hoveredSprite.draw(g, this.x, this.y);
        } else {
            this.normalSprite.draw(g, this.x, this.y);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Sprite gethoveredSprite() {
        return this.hoveredSprite;
    }

    public Sprite getNormalSprite() {
        return this.normalSprite;
    }

    public String getButtonType() {
        return this.buttonType;
    }

    public void setMouseOver(boolean mouseOver) {
        this.mouseOver = mouseOver;
    }
}

